<?php

/**
 * @version    CVS: 1.0.0
 * @package    Com_Mmap
 * @author     David <davidgeorgespam@gmail.com>
 * @copyright  2017 David
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

jimport('joomla.application.component.modellist');

/**
 * Methods supporting a list of Mmap records.
 *
 * @since  1.6
 */
class MmapModelMmaps extends JModelList
{
	/**
	 * Constructor.
	 *
	 * @param   array  $config  An optional associative array of configuration settings.
	 *
	 * @see        JController
	 * @since      1.6
	 */
	public function __construct($config = array())
	{
		if (empty($config['filter_fields']))
		{
			$config['filter_fields'] = array(
				'id', 'a.id',
				'category', 'a.category',
				'title', 'a.title',
				'visit', 'a.visit',
				'select', 'a.select',
				'from', 'a.from',
				'where', 'a.where',
				'group', 'a.group',
				'ordering', 'a.ordering',
				'state', 'a.state',
				'created_by', 'a.created_by',
				'modified_by', 'a.modified_by',
			);
		}

		parent::__construct($config);
	}

	/**
	 * Method to auto-populate the model state.
	 *
	 * Note. Calling getState in this method will result in recursion.
	 *
	 * @param   string  $ordering   Elements order
	 * @param   string  $direction  Order direction
	 *
	 * @return void
	 *
	 * @throws Exception
	 *
	 * @since    1.6
	 */
	protected function populateState($ordering = null, $direction = null)
	{
		$app  = JFactory::getApplication();
		$list = $app->getUserState($this->context . '.list');

		$ordering  = isset($list['filter_order'])     ? $list['filter_order']     : null;
		$direction = isset($list['filter_order_Dir']) ? $list['filter_order_Dir'] : null;

		$list['limit']     = (int) JFactory::getConfig()->get('list_limit', 20);
		$list['start']     = $app->input->getInt('start', 0);
		$list['ordering']  = $ordering;
		$list['direction'] = $direction;

		$app->setUserState($this->context . '.list', $list);
		$app->input->set('list', null);

		// List state information.
		parent::populateState($ordering, $direction);

        $app = JFactory::getApplication();

        $ordering  = $app->getUserStateFromRequest($this->context . '.ordercol', 'filter_order', $ordering);
        $direction = $app->getUserStateFromRequest($this->context . '.orderdirn', 'filter_order_Dir', $ordering);

        $this->setState('list.ordering', $ordering);
        $this->setState('list.direction', $direction);

        $start = $app->getUserStateFromRequest($this->context . '.limitstart', 'limitstart', 0, 'int');
        $limit = $app->getUserStateFromRequest($this->context . '.limit', 'limit', 0, 'int');

        if ($limit == 0)
        {
            $limit = $app->get('list_limit', 0);
        }

        $this->setState('list.limit', $limit);
        $this->setState('list.start', $start);
	}

	/**
	 * Build an SQL query to load the list data.
	 *
	 * @return   JDatabaseQuery
	 *
	 * @since    1.6
	 */
	protected function getListQuery()
	{
		
		
		
		
		
		
		
		
		
		// Create a new query object.
		$db    = $this->getDbo();
		$query = $db->getQuery(true);

        $query->select('category.*, category.title as category');
        $query->from($db->quoteName('#__categories', 'category'));
        $query->where('category.extension = ' . $db->quote('com_mmap'));
        $query->order($db->escape('lft ASC'));

/**
		// Select the required fields from the table.
		$query
			->select(
				$this->getState(
					'list.select', 'DISTINCT a.*'
				)
			);

		$query->from('`#__mmap` AS a');
		
		// Join over the users for the checked out user.
		$query->select('uc.name AS uEditor');
		$query->join('LEFT', '#__users AS uc ON uc.id=a.checked_out');
		// Join over the category 'category'
		$query->select('categories_2838947.title AS category');
		$query->join('LEFT', '#__categories AS categories_2838947 ON categories_2838947.id = a.category');

		// Join over the created by field 'created_by'
		$query->join('LEFT', '#__users AS created_by ON created_by.id = a.created_by');

		// Join over the created by field 'modified_by'
		$query->join('LEFT', '#__users AS modified_by ON modified_by.id = a.modified_by');
		
		if (!JFactory::getUser()->authorise('core.edit', 'com_mmap'))
		{
			$query->where('a.state = 1');
		}

		// Filter by search in title
		$search = $this->getState('filter.search');

		if (!empty($search))
		{
			if (stripos($search, 'id:') === 0)
			{
				$query->where('a.id = ' . (int) substr($search, 3));
			}
			else
			{
				$search = $db->Quote('%' . $db->escape($search, true) . '%');
			}
		}
		

		// Filtering category
		$filter_category = $this->state->get("filter.category");

		if ($filter_category)
		{
			$query->where("a.`category` = '" . $db->escape($filter_category) . "'");
		}

		// Filtering visit
		$filter_visit = $this->state->get("filter.visit");

		if ($filter_visit !== null && (is_numeric($filter_visit) || !empty($filter_visit)))
		{
			$query->where("a.`visit` = '".$db->escape($filter_visit)."'");
		}

		// Add the list ordering clause.
		$orderCol  = $this->state->get('list.ordering');
		$orderDirn = $this->state->get('list.direction');

		if ($orderCol && $orderDirn)
		{
			$query->order($db->escape($orderCol . ' ' . $orderDirn));
		}
*/
		return $query;
	}

	/**
	 * Method to get an array of data items
	 *
	 * @return  mixed An array of data on success, false on failure.
	 */
	public function getItems()
	{
		$items = parent::getItems();
		
		foreach ($items as $item)
		{

			if (isset($item->category))
			{

				// Get the title of that particular template
					$title = MmapHelpersMmap::getCategoryNameByCategoryId($item->category);

					// Finally replace the data object with proper information
					$item->category = !empty($title) ? $title : $item->category;
				}
				$item->visit = empty($item->visit) ? '' : JText::_('COM_MMAP_MMAPS_VISIT_OPTION_' . strtoupper($item->visit));
				
				
				$params = $this->getCategoryItems($item->id); 
				
				foreach($params as $param) {
				    $param->value = NULL;
				    $param->sd = NULL;
				    $param->n = NULL;
				    
				    $db    = JFactory::getDbo();
		            $query = $db->getQuery(true);
		            
		            if(!empty(trim($param->select))) {
		                $query->select(trim($param->select));
		            }
		            
		            if(strpos($param->select, 'as n') === false ) {
		                $query->select('count(*) as n');
		            }
		            
            		switch(trim($param->from)) {
            		    case 'users':
                            $query->from($db->quoteName('users', 'u'));
            		    break;  
            		    case 'patients': 
            		        $query->from($db->quoteName('patients', 'p'));
            		        $query->join('LEFT', $db->quoteName('users', 'u') . ' ON u.id = p.user_id '); 
            		    break; 
            		    case 'pt_entry':
                		    $query->from($db->quoteName('pt_entry', 'pe'));
                		    $query->join('LEFT', $db->quoteName('patients', 'p') . ' ON p.id = pe.patient_id ');
                		    $query->join('LEFT', $db->quoteName('users', 'u') . ' ON u.id = p.user_id '); 
                		    
                		    // Select only record that have a follow up visit 
                		    $query->where('(SELECT count(patient_id) FROM pt_entry  WHERE patient_id = pe.patient_id) = 2'); 
            		    break; 
            		    case 'medications': 
            		        $query->from($db->quoteName('medications', 'm'));
            		        $query->join('LEFT', $db->quoteName('medications_map', 'mm') . ' ON mm.id = m.med_id');
            		        $query->join('LEFT', $db->quoteName('pt_entry', 'pe') . ' ON pe.id = m.pt_entry_id');
                		    $query->join('LEFT', $db->quoteName('patients', 'p') . ' ON p.id = pe.patient_id ');
                		    $query->join('LEFT', $db->quoteName('users', 'u') . ' ON u.id = p.user_id '); 
                		    
                		    // Select only record that have a follow up visit 
                		    $query->where('(SELECT count(patient_id) FROM pt_entry  WHERE patient_id = pe.patient_id) = 2'); 
            		    break; 
            		}
            			
            		if($param->where) {
            		    $where = explode('~~', $param->where); 
            		    
            		    if(count($where) == 2) {
            		        $conditions = explode('||', $where[0]); 
            		        
            		        
            		        $query->where($where[1]);    
            		    } else {
            		        $query->where($param->where);    
            		    }
            		    
            		    
            		    /**
            		    
            		    */
            		    
            		    
            		}
            		
            		// Remove servier and Allori pts 
            		$query->where('u.email NOT LIKE ' . $db->quote('%@servier%') . ' AND u.email NOT LIKE ' . $db->quote('%@allori%') . ' AND u.aphra_number NOT LIKE ' . $db->quote('SER0020170404'));
            		
            		
            		
            		
            		
            		    $query->order('n DESC'); 
            		
            		if($param->group) {
            		    $query->group($param->group); 
            		}
		            $db->setQuery($query);
		
		            $param->query = $query->dump(); 
		            //echo $param->title; 
//echo $query->dump(); 
		            
$result = $db->loadObjectList();
                    
                    $param->result = $result;
                    
                    /**
                    if(property_exists($result, 'value')) $param->value = $result->value;
                    if(property_exists($result, 'sd')) $param->sd = $result->sd;
                    if(property_exists($result, 'n')) $param->n = $result->n;
                    */
				    
				    
				    
				    
				    
				    
				    
				    
				}
				$item->items = $params;
				
		}

		return $items;
	}

	/**
	 * Overrides the default function to check Date fields format, identified by
	 * "_dateformat" suffix, and erases the field if it's not correct.
	 *
	 * @return void
	 */
	protected function loadFormData()
	{
		$app              = JFactory::getApplication();
		$filters          = $app->getUserState($this->context . '.filter', array());
		$error_dateformat = false;

		foreach ($filters as $key => $value)
		{
			if (strpos($key, '_dateformat') && !empty($value) && $this->isValidDate($value) == null)
			{
				$filters[$key]    = '';
				$error_dateformat = true;
			}
		}

		if ($error_dateformat)
		{
			$app->enqueueMessage(JText::_("COM_MMAP_SEARCH_FILTER_DATE_FORMAT"), "warning");
			$app->setUserState($this->context . '.filter', $filters);
		}

		return parent::loadFormData();
	}

	/**
	 * Checks if a given date is valid and in a specified format (YYYY-MM-DD)
	 *
	 * @param   string  $date  Date to be checked
	 *
	 * @return bool
	 */
	private function isValidDate($date)
	{
		$date = str_replace('/', '-', $date);
		return (date_create($date)) ? JFactory::getDate($date)->format("Y-m-d") : null;
	} 
	
	private function getCategoryItems($id) {
	    $db    = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query
			->select('*')
			->from('#__mmap')
			->where('category = ' . $db->quote($id))
			->where('state = 1')
			->order('ordering ASC');
			
		$db->setQuery($query);
		
		//echo $query->dump(); 

		return $db->loadObjectList();
	    
	}
}




/** 
 * CHECK if patients have had a follow up visit 
 * WHERE (SELECT count(patient_id) FROM  pt_entry  WHERE patient_id = pe.patient_id) = 2 
 * 
 * 
 * 
 * SELECT `id`,`patient_id`,`visit`,`gender`,`patient_consent`,`height`,`weight`,`waist_circumference` 
FROM pt_entry as pe 
WHERE ( SELECT count(patient_id) FROM  pt_entry  WHERE patient_id = pe.patient_id) = 2 AND visit = 1 
ORDER BY patient_id 


 * 
 * Get averages based on switching - basic 
 * SELECT visit, '0' as switch_antipsychotic_medication, AVG(NULLIF (`weight` / POWER(`height` / 100, 2), 0)) AS BMI, avg(NULLIF(weight, 0)) as weight, avg(NULLIF(`waist_circumference`,0)) as wasit, avg(NULLIF(`fasting_plasma_glucose`, 0)) as glucose, avg(NULLIF(`total_cholesterol`, 0)) as total_cholesterol, avg(NULLIF(`ldl_cholesterol`, 0)) as LDL, avg(NULLIF(`hdl_cholesterol`, 0)) as HDL, avg(NULLIF(`triglycerides`, 0)) as Trig, avg(NULLIF(`systolic`, 0)) as sys, avg(NULLIF(`diastolic`, 0)) as dia, sum(`overweight`), sum(`waist_above_normal`), sum(`elevated_fasting_plasma_glucose`), sum(`dyslipidaemia`), sum(`switch_antipsychotic_medication`) 

FROM pt_entry AS pe 
LEFT JOIN patients AS p ON p.id = pe.patient_id 
LEFT JOIN users AS u ON u.id = p.user_id 
WHERE u.email NOT LIKE '%@servier%' AND u.email NOT LIKE '%@allori%' AND u.aphra_number NOT LIKE 'SER0020170404' 

AND visit = 2
AND pe.patient_id NOT IN (SELECT GROUP_CONCAT(patient_id) FROM pt_entry WHERE switch_antipsychotic_medication = 1 AND visit = 1);



SELECT visit, 'total' as switch_antipsychotic_medication, AVG(NULLIF (`weight` / POWER(`height` / 100, 2), 0)) AS BMI, avg(NULLIF(weight, 0)) as weight, avg(NULLIF(`waist_circumference`,0)) as wasit, avg(NULLIF(`fasting_plasma_glucose`, 0)) as glucose, avg(NULLIF(`total_cholesterol`, 0)) as total_cholesterol, avg(NULLIF(`ldl_cholesterol`, 0)) as LDL, avg(NULLIF(`hdl_cholesterol`, 0)) as HDL, avg(NULLIF(`triglycerides`, 0)) as Trig, avg(NULLIF(`systolic`, 0)) as sys, avg(NULLIF(`diastolic`, 0)) as dia, sum(`overweight`), sum(`waist_above_normal`), sum(`elevated_fasting_plasma_glucose`), sum(`dyslipidaemia`), sum(`switch_antipsychotic_medication`) 
FROM pt_entry AS pe 
LEFT JOIN patients AS p ON p.id = pe.patient_id 
LEFT JOIN users AS u ON u.id = p.user_id 
WHERE u.email NOT LIKE '%@servier%' AND u.email NOT LIKE '%@allori%' AND u.aphra_number NOT LIKE 'SER0020170404' 
AND visit = 2;









SELECT `patient_id`, `visit`, `hdl_cholesterol`, 'male' as gender 
FROM pt_entry as pe 

WHERE visit = 2 
AND (SELECT gender from pt_entry WHERE patient_id = pe.patient_id AND visit = 1) = 'female';


SELECT GROUP_CONCAT(patient_id) FROM pt_entry WHERE switch_antipsychotic_medication = 1 and visit = 1;

//SELECT * FROM pt_entry WHERE patient_id IN(40,42,44,45,55,62,65,68,75,76,85,86,88,92) AND visit = 2;


SELECT `id`,`patient_id`,`visit`,`gender`,`patient_consent`,`height`,`weight`,`waist_circumference` 
FROM pt_entry as pe 
WHERE ( SELECT count(patient_id) FROM  pt_entry  WHERE patient_id = pe.patient_id) = 2 AND visit = 1 
ORDER BY patient_id 


SELECT `id`,`patient_id`,`visit`,`gender`,`patient_consent`,`height`,`weight`,`waist_circumference` 
FROM pt_entry as pe 
WHERE ( SELECT count(patient_id) FROM  pt_entry  WHERE patient_id = pe.patient_id) = 2 
AND ( SELECT count(patient_id) FROM  pt_entry  WHERE patient_id = pe.patient_id AND visit = 1 AND switch_antipsychotic_medication = 1) = 1 
AND visit = 2 
ORDER BY patient_id ; 

SELECT `id`,`patient_id`,`visit`,`gender`,`patient_consent`,`height`,`weight`,`waist_circumference` 
FROM pt_entry as pe 
WHERE ( SELECT count(patient_id) FROM  pt_entry  WHERE patient_id = pe.patient_id) = 2 
AND ( SELECT count(patient_id) FROM  pt_entry  WHERE patient_id = pe.patient_id AND visit = 1 AND switch_antipsychotic_medication = 0) = 1
AND visit = 2 
ORDER BY patient_id ; 





SELECT * FROM pt_entry WHERE switch_antipsychotic_medication = 0 AND  adjust_dose_of_current_antipsychotic_medication = 0 AND  lifestyle_intervention = 0 AND commence_other_specific_therapy = 0 AND other = 0 ;

SELECT * FROM pt_entry WHERE switch_antipsychotic_medication IS NULL AND  adjust_dose_of_current_antipsychotic_medication IS NULL AND  lifestyle_intervention IS NULL AND commence_other_specific_therapy IS NULL AND other IS NULL;


SELECT id, (switch_antipsychotic_medication + adjust_dose_of_current_antipsychotic_medication  + lifestyle_intervention + commence_other_specific_therapy + other) as value, count(*) as n FROM `pt_entry` 

WHERE visit = 1

GROUP BY (switch_antipsychotic_medication + adjust_dose_of_current_antipsychotic_medication  + lifestyle_intervention + commence_other_specific_therapy + other);




 * */ 
