<?php

/**
 * @version    CVS: 1.0.0
 * @package    Com_Mmap
 * @author     David <davidgeorgespam@gmail.com>
 * @copyright  2017 David
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */
// No direct access.
defined('_JEXEC') or die;

jimport('joomla.application.component.modelitem');
jimport('joomla.event.dispatcher');

use Joomla\Utilities\ArrayHelper;

/**
 * Mmap model.
 *
 * @since  1.6
 */
class MmapModelFunc extends JModelItem
{
    
    /*** 
    * Base Table Structure 
    * 
    * patients 
    * surveys 
    * users 
    * visits 
    * 
    * 
    * 
    * #1 Create Table Structure - altr and create tables 
    * #2 Get the 'visits' table data - change to PHP Object and add back to pt_entry 
    * #3 Re-populate Patient Table from pt_entry 
    * 
    * 
    */
    
    // #1 
    public function createTableStructre() {
        
        $db    = JFactory::getDbo();
        
        try {
            $db->transactionStart();
            
            /**
            $query = "SET FOREIGN_KEY_CHECKS=0;"; 
            $db->setQuery($query)->execute();
            
            $query = "TRUNCATE TABLE surveys;";
            $db->setQuery($query)->execute();
            
            $query = "TRUNCATE TABLE medications;"; 
            $db->setQuery($query)->execute();
            
            $query = "TRUNCATE TABLE pt_entry;";
            $db->setQuery($query)->execute();
            
            $query = "TRUNCATE TABLE visits;";
            $db->setQuery($query)->execute();
            
            $query = "TRUNCATE TABLE patients;";
            $db->setQuery($query)->execute();
            
            $query = "TRUNCATE TABLE users;";
            $db->setQuery($query)->execute();
            
            $query = "SET FOREIGN_KEY_CHECKS=1;";
            $db->setQuery($query)->execute();
            */
    		
            //add new columns to the patiets table 
            
            // Add NEW Tables - medications 
            
            
            $query = "DROP TABLE IF EXISTS `medications`";
            $db->setQuery($query)->execute();
            
            $query = "CREATE TABLE IF NOT EXISTS `medications` (
              `id` int(11) NOT NULL AUTO_INCREMENT,
              `pt_entry_id` int(11) NOT NULL,
              `counts` int(11) DEFAULT NULL,
              `med_id` int(11) DEFAULT NULL,
              `name` varchar(255) DEFAULT NULL,
              `dose_mg` int(11) DEFAULT NULL,
              `duration_days` int(11) DEFAULT NULL,
              `duration_months` int(11) DEFAULT NULL,
              `duration_years` int(11) DEFAULT NULL,
              `total_duration_years` float DEFAULT NULL,
              `frequency` varchar(255) DEFAULT NULL,
              `frequency_other` varchar(255) DEFAULT NULL,
              `route` varchar(255) DEFAULT NULL,
              PRIMARY KEY (`id`)
            ) ENGINE=MyISAM AUTO_INCREMENT=1077 DEFAULT CHARSET=utf8";
            $db->setQuery($query)->execute();
    
    
            //CREATE pt_entry and truncate 
            
            $query = "DROP TABLE IF EXISTS `pt_entry`";
            $db->setQuery($query)->execute();
            
            $query = $db->getQuery(true);
            $query = "CREATE TABLE IF NOT EXISTS `pt_entry` (
              `id` int(11) NOT NULL AUTO_INCREMENT,
              `patient_id` int(11) DEFAULT NULL,
              `visit` int(1) DEFAULT NULL,
              `num_meds` int(3) DEFAULT NULL,
              `gender` varchar(255) NOT NULL,
              `patient_consent` int(1) NOT NULL,
              `height` int(5) DEFAULT NULL,
              `weight` int(255) DEFAULT NULL,
              `bmi` float DEFAULT NULL,
              `waist_circumference` varchar(255) DEFAULT NULL,
              `fasting_plasma_glucose` varchar(255) DEFAULT NULL,
              `total_cholesterol` float DEFAULT NULL,
              `ldl_cholesterol` float DEFAULT NULL,
              `hdl_cholesterol` float DEFAULT NULL,
              `triglycerides` float DEFAULT NULL,
              `systolic` int(4) DEFAULT NULL,
              `diastolic` int(4) DEFAULT NULL,
              `overweight` int(2) DEFAULT NULL,
              `waist_above_normal` int(2) DEFAULT NULL,
              `elevated_fasting_plasma_glucose` int(2) DEFAULT NULL,
              `dyslipidaemia` int(2) DEFAULT NULL,
              `hypertension` varchar(255) NOT NULL,
              `switch_antipsychotic_medication` int(2) DEFAULT NULL,
              `new_medication` varchar(255) DEFAULT NULL,
              `adjust_dose_of_current_antipsychotic_medication` int(2) DEFAULT NULL,
              `lifestyle_intervention` int(2) DEFAULT NULL,
              `commence_other_specific_therapy` int(2) DEFAULT NULL,
              `other` int(2) DEFAULT NULL,
              `comments` text,
              `time_until_next_review` int(3) DEFAULT NULL,
              `medications` text,
              `ongoing_management_plan` text,
              `created_at` datetime DEFAULT NULL,
              `updated_at` datetime DEFAULT NULL,
              `occurred_on` datetime DEFAULT NULL,
              PRIMARY KEY (`id`)
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8";
            $db->setQuery($query)->execute();
            
            
            
            $query = "DROP TABLE IF EXISTS `surveys_data_57`";
            $db->setQuery($query)->execute();
            
            $query = $db->getQuery(true);
            $query = "CREATE TABLE IF NOT EXISTS `surveys_data_57` (
              `id` int(11) NOT NULL AUTO_INCREMENT,
              
              `user_id` int(11) DEFAULT NULL,
              `page_id` int(11) DEFAULT NULL,
              `relevant` int(3) DEFAULT NULL,
              `learning_effective` int(3) DEFAULT NULL,
              `audit_useful` int(3) DEFAULT NULL,
              `likely_to_implement` int(3) DEFAULT NULL,
              `changed_practice` text DEFAULT NULL,
              `commit` varchar(255) DEFAULT NULL, 
              `created_at` datetime DEFAULT NULL,
              `updated_at` datetime DEFAULT NULL,
              PRIMARY KEY (`id`)
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8";
            $db->setQuery($query)->execute();
            
            
            $query = "DROP TABLE IF EXISTS `surveys_data_55`";
            $db->setQuery($query)->execute();
            
            $query = $db->getQuery(true);
            $query = "CREATE TABLE IF NOT EXISTS `surveys_data_55` (
              `id` int(11) NOT NULL AUTO_INCREMENT,
              `user_id` int(11) DEFAULT NULL,
              `page_id` int(11) DEFAULT NULL,
              `metabolic_adverse_effects` text DEFAULT NULL, 
              `metabolic_proportion` text DEFAULT NULL, 
              `review_frequency` text DEFAULT NULL, 
              `gender` varchar(25) DEFAULT NULL, 
              `years_of_practice` varchar(255) DEFAULT NULL, 
              `patients` varchar(255) DEFAULT NULL, 
              `setting` varchar(255) DEFAULT NULL,
              `commit` varchar(255) DEFAULT NULL, 
              `created_at` datetime DEFAULT NULL,
              `updated_at` datetime DEFAULT NULL,
              PRIMARY KEY (`id`)
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8";
            $db->setQuery($query)->execute();
            
            
            $db->transactionCommit();
        } catch (Exception $e) {
            // catch any database errors.
            $db->transactionRollback();
            JErrorPage::render($e);
        }
    }
    
    public function getUsers() {
	    $db    = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query
			->select('*')
			->from('users');
		$db->setQuery($query);
		
		echo $query->dump(); 

		return $db->loadObjectList();
	}
    
    public function setUserEntries() {
	    $db = JFactory::getDbo();
	    $users = $this->getUsers(); 
	    
	    $query = "ALTER TABLE `users` ADD COLUMN `address_state` varchar(255) DEFAULT NULL AFTER `address`";
        $db->setQuery($query)->execute();
        
	    foreach ($users as $user) {
	        $entry = new stdClass; 
	        $address = json_decode($user->address); 
	        
	        if(is_object($address) && property_exists($address, 'state')) {
	            $entry->id = $user->id;
	            $entry->address_state = $address->state; 
	            $result = $db->updateObject('users', $entry, 'id');    
	        }
	    }
	}
	
    
    // #2a 
    public function getVisits() {
	    $db    = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query
			->select('*')
			->from('visits');
		$db->setQuery($query);
		
		echo $query->dump(); 

		return $db->loadObjectList();
	       
	}
	
	# 2b
	public function setPtEntries() {
	    $db = JFactory::getDbo();
	    $visits = $this->getVisits(); 
	    
	    // Empty the table 
        $query = "TRUNCATE TABLE pt_entry"; 
        $db->setQuery($query);
        $db->execute(); 
	    
	    foreach ($visits as $visit) {
	        $entry = new stdClass; 
	        
	        $entry->id = $visit->id; 
	        $entry->patient_id  = $visit->patient_id;
	        
	        $entry->created_at = $visit->created_at;
	        $entry->updated_at = $visit->updated_at; 
	        $entry->occurred_on = $visit->occurred_on; 
	        
	        $data = json_decode($visit->data); 
	        
	        // Default visit 
	        $entry->visit = 2; 
	        foreach($data as $key => $param) {
	            if(is_object($param) || is_array($param)) {
	                $entry->{$key} = json_encode($param); 
	            } else {
	                
	                switch($key) {
	                    case 'comments':
	                    case 'medications':
	                    case 'ongoing_management_plan':
	                    case 'created_at':
	                    case 'updated_at': 
	                    case 'occurred_on': 
	                        
	                    break; 
	                    default;
	                        $param = preg_replace("/[^0-9,.]/", "", $param);  
	                    break; 
	                }
	                
	                $entry->{$key} = $param;   
	                
	            }
	            
	            // Find visit 1 
	            if($key == 'gender' && ($param == 'male' || $param == 'female')) {
	                $entry->visit = 1; 
	            } 
	        }
	        $result = $db->insertObject('pt_entry', $entry);
	    }
	    $this->generateBMI(); 
	    $this->cleanPtEntry(); 
	    $this->setPatientTable();
	}
	
	/** 
	 * Function to set zero and empty values to NULL in the databse 
	 * 
	 * */ 

    // ## 2c 
	public function cleanPtEntry() {
	    
	    $db    = JFactory::getDbo();
	    $columns = array('height', 'weight', 'waist_circumference', 'fasting_plasma_glucose', 'total_cholesterol', 'ldl_cholesterol', 'hdl_cholesterol', 'triglycerides', 'systolic', 'diastolic'); 
	    
	    foreach($columns as $column) {
	    
    		$query = $db->getQuery(true);
    		$query
    			->update('pt_entry')
    			->set($db->quoteName($column) . ' = NULL')
    			->where($db->quoteName($column) . " = '' OR " . $db->quoteName($column) . ' = 0'); 
    		$db->setQuery($query);
    		
    		echo $query->dump(); 
    		$db->execute(); 
	    }
	}
	
	// ## 2d 
	public function generateBMI() {
	    $db    = JFactory::getDbo();
	    
    	$query = $db->getQuery(true);
    	$query
    		->update('pt_entry')
    		->set('bmi =  (weight / POWER(height / 100, 2))');
    	$db->setQuery($query);
    	echo $query->dump(); 
    		
    	return $db->execute(); 
	}
	
	//#3 Repopulate Patient Table 
    
    public function setPatientTable() {
        $db    = JFactory::getDbo();
        
        try {
            $db->transactionStart();
            
            /// NEED TO ADD CHECKS if these coluns exist and not add if they do 
            $query = "ALTER TABLE patients 
                ADD COLUMN gender varchar(25), 
                ADD COLUMN overweight int(1),
                ADD COLUMN waist_above_normal int(1),
                ADD COLUMN elevated_fasting_plasma_glucose int(1),
                ADD COLUMN dyslipidaemia int(1),
                ADD COLUMN hypertension int(1),
                ADD COLUMN switch_antipsychotic_medication int(1),
                ADD COLUMN new_medication varchar(255),
                ADD COLUMN adjust_dose_of_current_antipsychotic_medication int(1),
                ADD COLUMN lifestyle_intervention int(1),
                ADD COLUMN commence_other_specific_therapy int(1),
                ADD COLUMN other int(1),
                ADD COLUMN comments text,
                ADD COLUMN time_until_next_review int(3),
                ADD COLUMN patient_consent int(1)"; 
            $db->setQuery($query);
            
            $db->execute(); 
           
            $query = "UPDATE
                patients p,
                pt_entry
            SET
                p.gender = pt_entry.gender,
                p.overweight = pt_entry.overweight,
                p.waist_above_normal = pt_entry.waist_above_normal,
                p.elevated_fasting_plasma_glucose = pt_entry.elevated_fasting_plasma_glucose,
                p.dyslipidaemia = pt_entry.dyslipidaemia,
                p.hypertension = pt_entry.hypertension,
                p.switch_antipsychotic_medication = pt_entry.switch_antipsychotic_medication,
                p.new_medication = pt_entry.new_medication,
                p.adjust_dose_of_current_antipsychotic_medication = pt_entry.adjust_dose_of_current_antipsychotic_medication,
                p.lifestyle_intervention = pt_entry.lifestyle_intervention,
                p.commence_other_specific_therapy = pt_entry.commence_other_specific_therapy,
                p.other = pt_entry.other,
                p.comments = pt_entry.comments,
                p.time_until_next_review = pt_entry.time_until_next_review,
                p.patient_consent = pt_entry.patient_consent        
            WHERE
                pt_entry.patient_id = p.id AND pt_entry.visit = 1"; 
            $db->setQuery($query);
            
            $db->execute(); 
            
            $query = "ALTER TABLE pt_entry  
                DROP COLUMN gender, 
                DROP COLUMN overweight,
                DROP COLUMN waist_above_normal,
                DROP COLUMN elevated_fasting_plasma_glucose,
                DROP COLUMN dyslipidaemia,
                DROP COLUMN hypertension,
                DROP COLUMN switch_antipsychotic_medication,
                DROP COLUMN new_medication,
                DROP COLUMN adjust_dose_of_current_antipsychotic_medication,
                DROP COLUMN lifestyle_intervention,
                DROP COLUMN commence_other_specific_therapy,
                DROP COLUMN other,
                DROP COLUMN time_until_next_review,
                DROP COLUMN patient_consent"; 
            $db->setQuery($query);
            $db->execute();
            
            $db->transactionCommit();
        } catch (Exception $e) {
            // catch any database errors.
            $db->transactionRollback();
            JErrorPage::render($e);
        }
    }
    
    public function getMedicationsFromPt() {
	    $db    = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query
			->select('id, medications')
			->from('pt_entry');
		$db->setQuery($query);
		
		echo $query->dump(); 

		return $db->loadObjectList();
	}
	/**
	public function setMedicationEntries() {
	    $db = JFactory::getDbo();
	    $meds = $this->getMedicationsFromPt(); 
	    
	    $query = "TRUNCATE medications"; 
        $db->setQuery($query);
        $db->execute(); 
	    
	    foreach ($meds as $med) {
	        
	        $entry = new stdClass; 
	        $entry->pt_entry_id = $med->id; 
	        $data = json_decode($med->medications); 
	        
	        foreach($data as $key => $param) {
	            if(is_object($param) || is_array($param)) {
	                $entry->{$key} = json_encode($param); 
	            } else {
	                $entry->{$key} = $param; 
	            }
	        }
	        $result = $db->insertObject('medications', $entry);
	    }
	}
	*/
	
	public function setMedicationEntries() {
	    $db    = JFactory::getDbo();
		$rows  = $this->getMedicationsFromPt(); 
	    
	    $query = "TRUNCATE TABLE medications"; 
        $db->setQuery($query);
        $db->execute(); 
		
		foreach($rows as $row) {
		    $medications = json_decode($row->medications); 
		    $count = count($medications); 
		    
		    $db    = JFactory::getDbo();
    		$query = $db->getQuery(true);
    		$query
    			->update($db->quoteName('pt_entry', 'pe'))
    			->set('num_meds = ' . $db->quote($count))
    			->where('pe.id = ' . $db->quote($row->id));
    		$db->setQuery($query)->execute(); 
    		
		    foreach($medications as $med) {
		        $med->pt_entry_id = $row->id;
		        $med->counts = $count; 

		        $result = JFactory::getDbo()->insertObject('medications', $med);
		    }
		}
		$this->setMedicationId(); 
		$this->setMedTotalYears();
		return $this->getMisingMeds(); 
	}
    
    public function setMedicationId () {
	    $db    = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query
			->select('mm.*')
			->from($db->quoteName('medications_map', 'mm'))
			//->join('LEFT', $db->quoteName('medications_class', 'c') . ' ON c.id = mm.class_id')
			->order('mm.ordering ASC');
		$db->setQuery($query);
		echo $query->dump(); 
		
		$rows = $db->loadObjectList(); 
		
		// First match exact brands and generics 
		foreach($rows as $row) {
		    $likes = array(); 
		    if(!empty($row->generic)) {
		        $likes[] = trim($row->generic);    
		    }
		    if(!empty($row->brand)) {
		        $likes[] = trim($row->brand);
		    }
		    
		    foreach ($likes as $key => $like) {
		        if(!empty($like)) {
		            $likes[$key] = 'm.name LIKE ' . $db->quote('%' . strtolower($like) . '%');    
		        }
		    }
		    
		    $likes = "(" . implode(' OR ', $likes) . ")";
		    
		    $query = $db->getQuery(true);
    		$query
    			->update($db->quoteName('medications', 'm'))
    			->set('m.med_id = ' . $db->escape($row->id))
    			->where($likes)
    			->where('(m.med_id IS NULL)'); 
    		$db->setQuery($query);
    		echo $query->dump(); 
    		$db->execute(); 
		    
		    //echo $query->dump(); 
		}
		
		// Then match any items with alias 
		foreach($rows as $row) {
		    $likes = array(); 
		    
		    if(!empty($row->alias)) {
		        $likes = explode(',', $row->alias);
		        
		        foreach ($likes as $key => $like) {
    		        if(!empty($like)) {
		                $likes[$key] = 'm.name LIKE ' . $db->quote('%' . strtolower(trim($like)) . '%');    
		            }
    		    }
    		    
    		    $likes = "(" . implode(' OR ', $likes) . ")";
    		    
    		    $query = $db->getQuery(true);
        		$query
        			->update($db->quoteName('medications', 'm'))
        			->set('m.med_id = ' . $db->escape($row->id))
        			->where($likes)
        			->where('m.med_id IS NULL'); 
        		$db->setQuery($query);
        		
        		echo $query->dump();  
        		
        		$db->execute(); 
    	    }
	    }
	}
	
	public function setPtEntryMedicationId () {
	    $db    = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query
			->select('mm.*')
			->from($db->quoteName('medications_map', 'mm'))
			->order('mm.ordering ASC');
		$db->setQuery($query);
		echo $query->dump(); 
		
		$rows = $db->loadObjectList(); 
		
		// First match exact brands and generics 
		foreach($rows as $row) {
		    $likes = array(); 
		    if(!empty($row->generic)) {
		        $likes[] = trim($row->generic);    
		    }
		    if(!empty($row->brand)) {
		        $likes[] = trim($row->brand);
		    }
		    
		    foreach ($likes as $key => $like) {
		        if(!empty($like)) {
		            $likes[$key] = 'p.new_medication LIKE ' . $db->quote('%' . strtolower($like) . '%');    
		        }
		    }
		    
		    $likes = "(" . implode(' OR ', $likes) . ")";
		    
		    $query = $db->getQuery(true);
    		$query
    			->update($db->quoteName('patients', 'p'))
    			->set('p.new_med_id = ' . $db->escape($row->id))
    			->where($likes)
    			->where('(p.new_med_id IS NULL)'); 
    		$db->setQuery($query);
    		echo $query->dump(); 
    		$db->execute(); 
		    
		    //echo $query->dump(); 
		}
		
		// Then match any items with alias 
		foreach($rows as $row) {
		    $likes = array(); 
		    
		    if(!empty($row->alias)) {
		        $likes = explode(',', $row->alias);
		        
		        foreach ($likes as $key => $like) {
    		        if(!empty($like)) {
		                $likes[$key] = 'p.new_medication LIKE ' . $db->quote('%' . strtolower(trim($like)) . '%');    
		            }
    		    }
    		    
    		    $likes = "(" . implode(' OR ', $likes) . ")";
    		    
    		    $query = $db->getQuery(true);
        		$query
        			->update($db->quoteName('pt_entry', 'pe'))
        			->set('p.new_med_id = ' . $db->escape($row->id))
        			->where($likes)
        			->where('p.new_med_id IS NULL'); 
        		$db->setQuery($query);
        		
        		echo $query->dump();  
        		
        		$db->execute(); 
    	    }
	    }
	}
	/**
	
	        $query = "UPDATE          pt_entry pe, 
                medications
            SET
                pe.num_meds = medications.counts,     
            WHERE
                medications.pt_entry_id = pe.id";
                 
            
            $db->setQuery($query);
            $db->execute(); 
            
            
            */
	
    public function setMedTotalYears() {
        $db    = JFactory::getDbo();
        $query = "UPDATE `medications` SET `total_duration_years` = ((`duration_days` / 365) + (`duration_months` /12) + `duration_years`)"; 
        $db->setQuery($query);
        return $db->execute(); 
    }
	
	
	public function getMisingMeds() {
        $db    = JFactory::getDbo();
        $query = "SELECT * FROM `medications` WHERE med_id IS NULL"; 
        $db->setQuery($query);
        return $db->loadObjectList(); 
    }
	
	public function getSurveys($page = null) {
	    $db    = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query
			->select('*')
			->from('surveys');
			if(!empty($page)) {
			    $query->where('page_id = ' . $db->quote($page));
			}
		$db->setQuery($query);
		
		echo $query->dump(); 

		return $db->loadObjectList();
	       
	}
	
	public function setSurveyEntries($page) {
	    $db = JFactory::getDbo();
	    $surveys = $this->getSurveys($page); 
	    
	    // Empty the table 
        $query = "TRUNCATE TABLE surveys_data_" . $page; 
        $db->setQuery($query);
        $db->execute(); 
        
	    foreach ($surveys as $visit) {
	        $entry = new stdClass; 
	        
	        
	        
	        $entry->id = $visit->id; 
	        $entry->page_id  = $visit->page_id; 
	        $entry->user_id  = $visit->user_id;
	        $entry->created_at = $visit->created_at;
	        $entry->updated_at = $visit->updated_at; 
	        $data = json_decode($visit->data); 
	        
	        // Default visit 
	        
	        foreach($data as $key => $param) {
	            if(is_object($param) || is_array($param)) {
	                $entry->{$key} = json_encode($param); 
	            } else {
	                $entry->{$key} = $param; 
	            }
	        }
	        $result = $db->insertObject('surveys_data_' . $page, $entry); 
	    }
	    
	}
	
	
	
	
	public function setVisitNumber() {
	    return false; 
	}
}

		
		/**
		 * UPDATE anti-pychoti names to normalise brands to generics 
		 * 
		 * 
		 * UPDATE `medications` AS m SET `med_id`= (SELECT mm.id FROM medications_map AS mm WHERE generic LIKE m.name) 
		 * 
		 * 
		 * UPDATE `medications` SET `name`= 'Lurasidone' WHERE name LIKE 'luras%' or name LIKE '%latuda%' or name LIKE 'lur%done'; 
UPDATE `medications` SET `name`= 'Olanzapine' WHERE name LIKE 'olanz%' or name LIKE 'zyprexa%' or name LIKE 'o%pine%'; 
UPDATE `medications` SET `name`= 'Aripiprazole' WHERE name LIKE 'aripip%' or name LIKE 'abilfy%' or name LIKE 'abilify%'; 
UPDATE `medications` SET `name`= 'Amisulpride' WHERE name LIKE 'amisulpiride%' or name LIKE 'Solian%'; 
UPDATE `medications` SET `name`= 'Asenapine' WHERE name LIKE 'Asenapine%' or name LIKE 'saphris%'; 
UPDATE `medications` SET `name`= 'Zuclopenthixol' WHERE name LIKE 'Zuclo%' or name LIKE 'Clopixol%'; 
UPDATE `medications` SET `name`= 'Clozapine' WHERE name LIKE 'Clozapine%' or name LIKE 'clopin%'; 
UPDATE `medications` SET `name`= 'Haloperidol' WHERE name LIKE 'Haloperidol%' or name LIKE 'haldol%' or name LIKE 'serenace%'; 
UPDATE `medications` SET `name`= 'Paliperidone' WHERE name LIKE 'Paliperidone%' or name LIKE 'trinza%' or name LIKE 'invega%'; 
UPDATE `medications` SET `name`= 'Risperidone' WHERE name LIKE 'Risperidone%' or name LIKE 'Risperdal%' or name LIKE 'consta%'; 
UPDATE `medications` SET `name`= 'Quetiapine' WHERE name LIKE 'Quetiapine%' or name LIKE 'seroquel%' or name LIKE 'Quietapine%' or name LIKE 'Quite%'; 
UPDATE `medications` SET `name`= 'Ziprasidone' WHERE name LIKE 'Zip%done%' or name LIKE 'zeldox%';

UPDATE `medications` SET `name`= 'Lithium' WHERE name LIKE 'Lithium%' or name LIKE 'Quilonum%'; 
UPDATE `medications` SET `name`= 'Valproate' WHERE name LIKE '%Valproate%' or name LIKE 'Epilim%'; 





UPDATE `medications` SET `name`= 'Flupentixol' WHERE name LIKE 'Flupentixol%' or name LIKE 'Depixol%';
UPDATE `medications` SET `name`= 'Periciazine' WHERE name LIKE 'Periciazine%' or name LIKE 'pericyazine%'; 
UPDATE `medications` SET `name`= 'Chlorpromazine' WHERE name LIKE 'Chlorpromazine%' or name LIKE 'Largactil%'; 
UPDATE `medications` SET `name`= 'Trifluoperazine' WHERE name LIKE 'Trifluoperazine%' or name LIKE 'Stelazine%'; 

UPDATE `medications` SET `name`= 'Carbamazepine' WHERE name LIKE 'Carbamazepine%' or name LIKE 'Tegretol%'; 
UPDATE `medications` SET `name`= 'Lamotrigine' WHERE name LIKE 'Lamotrigine%' or name LIKE 'Lamictal%'; 

UPDATE `medications` SET `name`= 'Amitriptyline' WHERE name LIKE 'Amitriptyline%' or name LIKE 'Endep%'; 
UPDATE `medications` SET `name`= 'Nortriptyline' WHERE name LIKE 'Nortriptyline%'; 
UPDATE `medications` SET `name`= 'Clomipramine' WHERE name LIKE 'Clomipramine%' or name LIKE 'Anafranil%'; 

UPDATE `medications` SET `name`= 'Venlafaxine' WHERE name LIKE 'Venlafaxine%' or name LIKE 'Velafaxine%' or name LIKE 'efexor%' or name LIKE 'Effexor%'; 
UPDATE `medications` SET `name`= 'Desvelafaxine' WHERE name LIKE 'Desvelafaxine%' or name LIKE 'pristiq%'; 
UPDATE `medications` SET `name`= 'Duloxetine' WHERE name LIKE 'Duloxetine%' or name LIKE 'Cymbalta%' or name LIKE 'Symbalta%'; 

UPDATE `medications` SET `name`= 'Citalopram' WHERE name LIKE 'Citalopram%' or name LIKE 'Cipramil%'; 
UPDATE `medications` SET `name`= 'Escitalopram' WHERE name LIKE 'Escitalopram%' or name LIKE 'Lexapro%'; 
UPDATE `medications` SET `name`= 'Paroxetine' WHERE name LIKE 'Paroxetine%'; 
UPDATE `medications` SET `name`= 'Sertraline' WHERE name LIKE 'Sertraline%' or name LIKE 'setraline%' or name LIKE 'zoloft%' or name LIKE 'Sertraine%'; 
UPDATE `medications` SET `name`= 'Mirtazapine' WHERE name LIKE 'Mirtazapine%' or name LIKE 'Mirtazipine%' or name LIKE 'Avanza%' or name LIKE 'Sertraine%'; 
UPDATE `medications` SET `name`= 'Fluoxetine' WHERE name LIKE 'Fluoxetine%' or name LIKE 'Prozac%'; 
UPDATE `medications` SET `name`= 'Fluvoxamine' WHERE name LIKE 'Fluoxetine%' or name LIKE 'Luvox%'; 


UPDATE `medications` SET `name`= 'Candesartan' WHERE name LIKE 'Candesartan%' or name LIKE 'Candesartran%';
UPDATE `medications` SET `name`= 'Metformin' WHERE name LIKE 'Metformin%'; 

UPDATE `medications` SET `name`= 'Atorvastatin' WHERE name LIKE 'Atorvastatin%' or name LIKE 'Lipitor%';
UPDATE `medications` SET `name`= 'Rosuvastatin' WHERE name LIKE 'Rosuvastatin%' or name LIKE 'crestor%';
UPDATE `medications` SET `name`= 'Fenofibrate' WHERE name LIKE 'Fenofibrate%' or name LIKE 'Tricor%';
UPDATE `medications` SET `name`= 'Dapagliflozin' WHERE name LIKE 'Dapagliflozin%' or name LIKE 'Forxiga%';


UPDATE `medications` SET `name`= 'Benztropine' WHERE name LIKE 'Benztropine%' or name LIKE 'Benzotropine%';



UPDATE `pt_entry` SET `new_medication`= 'Lurasidone' WHERE new_medication LIKE 'luras%' or new_medication LIKE '%latuda%' or new_medication LIKE 'lur%done'; 
UPDATE `pt_entry` SET `new_medication`= 'Olanzapine' WHERE new_medication LIKE 'olanz%' or new_medication LIKE 'zyprexa%' or new_medication LIKE 'o%pine%'; 
UPDATE `pt_entry` SET `new_medication`= 'Aripiprazole' WHERE new_medication LIKE 'aripip%' or new_medication LIKE 'abilfy%' or new_medication LIKE 'abilify%'; 
UPDATE `pt_entry` SET `new_medication`= 'Amisulpride' WHERE new_medication LIKE 'amisulpiride%' or new_medication LIKE 'Solian%'; 
UPDATE `pt_entry` SET `new_medication`= 'Asenapine' WHERE new_medication LIKE 'Asenapine%' or new_medication LIKE 'saphris%'; 
UPDATE `pt_entry` SET `new_medication`= 'Zuclopenthixol' WHERE new_medication LIKE 'Zuclo%' or new_medication LIKE 'Clopixol%'; 
UPDATE `pt_entry` SET `new_medication`= 'Clozapine' WHERE new_medication LIKE 'Clozapine%' or new_medication LIKE 'clopin%'; 
UPDATE `pt_entry` SET `new_medication`= 'Haloperidol' WHERE new_medication LIKE 'Haloperidol%' or new_medication LIKE 'haldol%' or new_medication LIKE 'serenace%'; 
UPDATE `pt_entry` SET `new_medication`= 'Paliperidone' WHERE new_medication LIKE 'Paliperidone%' or new_medication LIKE 'trinza%' or new_medication LIKE 'invega%'; 
UPDATE `pt_entry` SET `new_medication`= 'Risperidone' WHERE new_medication LIKE 'Risperidone%' or new_medication LIKE 'Risperdal%' or new_medication LIKE 'consta%'; 
UPDATE `pt_entry` SET `new_medication`= 'Quetiapine' WHERE new_medication LIKE 'Quetiapine%' or new_medication LIKE 'seroquel%' or new_medication LIKE 'Quietapine%' or new_medication LIKE 'Quite%'; 
UPDATE `pt_entry` SET `new_medication`= 'Ziprasidone' WHERE new_medication LIKE 'Zip%done%' or new_medication LIKE 'zeldox%';

UPDATE `pt_entry` SET `new_medication`= 'Lithium' WHERE new_medication LIKE 'Lithium%' or new_medication LIKE 'Quilonum%'; 
UPDATE `pt_entry` SET `new_medication`= 'Valproate' WHERE new_medication LIKE '%Valproate%' or new_medication LIKE 'Epilim%'; 





UPDATE `pt_entry` SET `new_medication`= 'Flupentixol' WHERE new_medication LIKE 'Flupentixol%' or new_medication LIKE 'Depixol%';
UPDATE `pt_entry` SET `new_medication`= 'Periciazine' WHERE new_medication LIKE 'Periciazine%' or new_medication LIKE 'pericyazine%'; 
UPDATE `pt_entry` SET `new_medication`= 'Chlorpromazine' WHERE new_medication LIKE 'Chlorpromazine%' or new_medication LIKE 'Largactil%'; 
UPDATE `pt_entry` SET `new_medication`= 'Trifluoperazine' WHERE new_medication LIKE 'Trifluoperazine%' or new_medication LIKE 'Stelazine%'; 

UPDATE `pt_entry` SET `new_medication`= 'Carbamazepine' WHERE new_medication LIKE 'Carbamazepine%' or new_medication LIKE 'Tegretol%'; 
UPDATE `pt_entry` SET `new_medication`= 'Lamotrigine' WHERE new_medication LIKE 'Lamotrigine%' or new_medication LIKE 'Lamictal%'; 

UPDATE `pt_entry` SET `new_medication`= 'Amitriptyline' WHERE new_medication LIKE 'Amitriptyline%' or new_medication LIKE 'Endep%'; 
UPDATE `pt_entry` SET `new_medication`= 'Nortriptyline' WHERE new_medication LIKE 'Nortriptyline%'; 
UPDATE `pt_entry` SET `new_medication`= 'Clomipramine' WHERE new_medication LIKE 'Clomipramine%' or new_medication LIKE 'Anafranil%'; 

UPDATE `pt_entry` SET `new_medication`= 'Venlafaxine' WHERE new_medication LIKE 'Venlafaxine%' or new_medication LIKE 'Velafaxine%' or new_medication LIKE 'efexor%' or new_medication LIKE 'Effexor%'; 
UPDATE `pt_entry` SET `new_medication`= 'Desvelafaxine' WHERE new_medication LIKE 'Desvelafaxine%' or new_medication LIKE 'pristiq%'; 
UPDATE `pt_entry` SET `new_medication`= 'Duloxetine' WHERE new_medication LIKE 'Cymbalta%' or new_medication LIKE 'Symbalta%'; 

UPDATE `pt_entry` SET `new_medication`= 'Citalopram' WHERE new_medication LIKE 'Citalopram%' or new_medication LIKE 'Cipramil%'; 
UPDATE `pt_entry` SET `new_medication`= 'Escitalopram' WHERE new_medication LIKE 'Escitalopram%' or new_medication LIKE 'Lexapro%'; 
UPDATE `pt_entry` SET `new_medication`= 'Paroxetine' WHERE new_medication LIKE 'Paroxetine%'; 
UPDATE `pt_entry` SET `new_medication`= 'Sertraline' WHERE new_medication LIKE 'Sertraline%' or new_medication LIKE 'setraline%' or new_medication LIKE 'zoloft%' or new_medication LIKE 'Sertraine%'; 
UPDATE `pt_entry` SET `new_medication`= 'Mirtazapine' WHERE new_medication LIKE 'Mirtazapine%' or new_medication LIKE 'Mirtazipine%' or new_medication LIKE 'Avanza%' or new_medication LIKE 'Sertraine%'; 
UPDATE `pt_entry` SET `new_medication`= 'Fluoxetine' WHERE new_medication LIKE 'Fluoxetine%' or new_medication LIKE 'Prozac%'; 
UPDATE `pt_entry` SET `new_medication`= 'Fluvoxamine' WHERE new_medication LIKE 'Fluoxetine%' or new_medication LIKE 'Luvox%'; 


UPDATE `pt_entry` SET `new_medication`= 'Candesartan' WHERE new_medication LIKE 'Candesartan%' or new_medication LIKE 'Candesartran%';
UPDATE `pt_entry` SET `new_medication`= 'Metformin' WHERE new_medication LIKE 'Metformin%'; 

UPDATE `pt_entry` SET `new_medication`= 'Atorvastatin' WHERE new_medication LIKE 'Atorvastatin%' or new_medication LIKE 'Lipitor%';
UPDATE `pt_entry` SET `new_medication`= 'Rosuvastatin' WHERE new_medication LIKE 'Rosuvastatin%' or new_medication LIKE 'crestor%';
UPDATE `pt_entry` SET `new_medication`= 'Fenofibrate' WHERE new_medication LIKE 'Fenofibrate%' or new_medication LIKE 'Tricor%';
UPDATE `pt_entry` SET `new_medication`= 'Dapagliflozin' WHERE new_medication LIKE 'Dapagliflozin%' or new_medication LIKE 'Forxiga%';


// Get years for each med and avg per users 
SELECT mm.generic, mm.brand, m.name, SUM((`duration_days` / 365) + (`duration_months` /12) + `duration_years`) as years, count(*) as total, SUM((`duration_days` / 365) + (`duration_months` /12) + `duration_years`)/count(*) as avg_years
FROM `medications` as m
LEFT JOIN medications_map as mm ON  mm.id = m.med_id
GROUP BY `med_id`


Periciazine, neulactil
Pantoprazole, Protonix
NovoMix FlexPen, NOVOMIX FLEXIPEN
Lercanidipine
Thyroxine
Quilonum
Moxonidine



User Report 



n Total Users 
n Users with > 1 patient 
n Users with >= 5 patient 

meas average pts screen 


Medications Report 


Switch from 'medications'
SELECT CONCAT(m.name, ' - ', pe.new_medication) as value
WHERE switch_antipsychotic_medication = 1 AND mm.class = 'antipsychotic'
GROUP CONCAT(m.name, ' - ', pe.new_medication)  





*/

