<?php
/**
 * @package     Joomla.Site
 * @subpackage  Templates.eswroughtiron
 *
 * @copyright   Copyright (C) 2014 Blueline Technology. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

// Getting params from template
$params = JFactory::getApplication()->getTemplate(true)->params;

$app = JFactory::getApplication();
$doc = JFactory::getDocument();
$this->language = $doc->language;
$this->direction = $doc->direction;

// Detecting Active Variables
$option   = $app->input->getCmd('option', '');
$view     = $app->input->getCmd('view', '');
$layout   = $app->input->getCmd('layout', '');
$task     = $app->input->getCmd('task', '');
$itemid   = $app->input->getCmd('Itemid', '');
$sitename = $app->getCfg('sitename');

$path_template = $this->baseurl . '/templates/' . $this->template;
$path_images = $path_template . '/images/';
$path_css = $path_template . '/css/';
$path_js = $path_template . '/js/';

// Add Stylesheets


$doc->addStyleSheet('https://maxcdn.bootstrapcdn.com/bootstrap/3.3.4/css/bootstrap.min.css');    

//$doc->addStyleSheet($path_css . 'bootstrap.min.css');    
$doc->addStyleSheet($path_css . 'style.css'); 

$doc->addScript($path_js . 'jquery.min.js');
$doc->addScript($path_js . 'bootstrap.min.js');
?>
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- The above 3 meta tags *must* come first in the head; any other head content must come *after* these tags -->
    <jdoc:include type="head" />
    <script src="http://thecodeplayer.com/uploads/js/prefixfree-1.0.7.js" type="text/javascript" type="text/javascript"></script>

    <!-- Bootstrap -->

    
    
    <!-- HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries -->
    <!--[if lt IE 9]>
      <script src="https://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
      <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
    <![endif]-->
  </head>
  <body>
  
  
  
    <!-- HEADER START -->   
    <header id="header" class="larger">    	
    	<div class="content">
	    
	<nav id="nav" class="navbar navbar-inverse navbar-fixed-top">
	  <div class="container">

	    <div class="navbar-header">
	      <a id="logo" class="navbar-brand" href="<?php echo $doc->baseUrl; ?>">        
	        <span id="logoImage" class="image img-responsive" role="img" aria-label="Blueline Technology Logo"></span>		        
	      </a>
	      
	      <button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#navbar-collapse">
	        <span class="sr-only">Toggle navigation</span>
	        <span class="icon-bar"></span>
	        <span class="icon-bar"></span>
	        <span class="icon-bar"></span>
	      </button>
	    </div>
	
	    <!-- Collect the nav links, forms, and other content for toggling -->
	    <div class="collapse navbar-collapse" id="navbar-collapse">
	<?php if ($this->countModules('position-1')) : ?>
	      <jdoc:include type="modules" name="position-1" style="none" />						
 	<?php endif; ?> 
 	
	     <?php if ($this->countModules('position-4')) : ?>
	       <jdoc:include type="modules" name="position-4" style="none" />							   
	     <?php endif; ?> 	

	     <?php if ($this->countModules('position-5')) : ?>
	       <jdoc:include type="modules" name="position-5" style="none" />							   
	     <?php endif; ?>  	
      	            
	    </div><!-- /.navbar-collapse -->
	  </div><!-- /.container-fluid -->
	</nav>
	</div>
    </header>	
    <!-- HEADER END -->   
        
    <section>      
      <div class="container-fluid">       
        <div class="row">
          <div class="col-sm-3 left" id="col-left">
            <?php if ($this->countModules('position-0')) : ?>
	    <jdoc:include type="modules" name="position-0" style="none" />						
            <?php endif; ?>
            
            <aside>
              <?php if ($this->countModules('position-8')) : ?>
              <jdoc:include type="modules" name="position-8" style="xhtml" />
              <?php endif; ?>              
              <?php 
              /**
              <h3>Social Networks</h3>
              <div id="social">
  	        <ul class="list-group social-share">
	          <li class="list-group-item"><div class="social-sprite facebook"><a href="#" target="_blank"></a></div></li>
	          <li class="list-group-item social-sprite twitter"><a href="#" target="_blank"></a></li>
	          <li class="list-group-item social-sprite linkedin"><a href="#" target="_blank"></a></li>
	          <li class="list-group-item social-sprite googleplus"><a href="#" target="_blank"></a></li>
	          <li class="list-group-item social-sprite instagram"><a href="#" target="_blank"></a></li>
	          <li class="list-group-item social-sprite pintrest"><a href="#" target="_blank"></a></li>
	          <li class="list-group-item social-sprite youtube"><a href="#" target="_blank"></a></li>	          	          	          	          
	        </ul>	      	      
	      </div>
	      */
	      ?>
            </aside>
            
          </div><!-- End Left Column --> 
          <div class="col-sm-9" id="col-main">  
            <?php if ($this->countModules('banner')) : ?>
            <section id="banner">
              <jdoc:include type="modules" name="banner" style="xhtml" />	
            </section>  
            <?php endif; ?> 
	    <main id="content" role="main">
	      <!-- Begin Content -->	      
	      <?php if ($this->countModules('position-3')) : ?>
	      <jdoc:include type="modules" name="position-3" style="xhtml" />	 
	      <div class="clearfix"></div>
	      <?php endif; ?>     
	      <jdoc:include type="message" />
	      <jdoc:include type="component" />
	      <div class="clearfix"></div>
	      <!-- a simple div with some links -->

	      <?php if ($this->countModules('position-2')) : ?>
	      <jdoc:include type="modules" name="position-2" style="none" />
	      <?php endif; ?>
	      <!-- End Content -->
            </main>                 
          </div><!-- End Main Column --> 
          <?php 
          /**
          <div class="col-sm-3" id="col-right">
            <aside>
	      <?php if ($this->countModules('position-7')) : ?>
              <jdoc:include type="modules" name="position-7" style="xhtml" />
              <?php endif; ?>           
            </aside>
          </div><!-- End Right Column -->    
          */
          ?>       
        </div><!-- End Row -->       
       </div><!-- End Container --> 
    </section>   
        
    <footer id="footer" class="footer" role="contentinfo">
    <div class="container">
      
      <div id="footer_top" class="row">
   <div class="col-sm-offset-3 col-sm-9">

      <div class="col-sm-2">
        <?php if ($this->countModules('position-9')) : ?>
        <jdoc:include type="modules" name="position-9" style="none" />	
        <?php endif; ?>       
      </div>
      <div class="col-sm-4">
        <?php if ($this->countModules('position-10')) : ?>
        <jdoc:include type="modules" name="position-10" style="none" />	
        <?php endif; ?>        
      </div>
      <div class="col-sm-3">
        <?php if ($this->countModules('position-11')) : ?>
        <jdoc:include type="modules" name="position-11" style="none" />	
        <?php endif; ?>  
      </div>            
      <div class="col-sm-3">
        <?php if ($this->countModules('position-12')) : ?>
        <jdoc:include type="modules" name="position-12" style="none" />	
        <?php endif; ?>  
      </div>       

</div>
      
      </div>
      <div id="footer_middle" class="row">
      
      </div>
      <div id="footer_bottom" class="row">
	      <?php if ($this->countModules('footer')) : ?>
	      <jdoc:include type="modules" name="footer" style="none" />
	      <?php endif; ?>
	      <?php if ($this->countModules('credits')) : ?>
	      <jdoc:include type="modules" name="credits" style="none" />
	      <?php endif; ?>      
      </div>         

      </div>
    </footer> 

    <script>
    $.noConflict();
	jQuery( document ).ready(function( $ ) {
	  // Code that uses jQuery's $ can follow here.
	/*Shrinks the header after scrolling down 50px */
  	$(window).scroll(function(){
	  if($(document).scrollTop() > 50){	
	    $('#header').removeClass('larger');
	  } else {
	    $('#header').addClass('larger');
	  }
	}); 	  
	});
    </script>
  </body>
</html>