<?php
/**
 * On-the-fly CSS Compression
 * Copyright (c) 2009 and onwards, Manas Tungare.
 * Creative Commons Attribution, Share-Alike.
 *
 * In order to minimize the number and size of HTTP requests for CSS content,
 * this script combines multiple CSS files into a single file and compresses
 * it on-the-fly.
 *
 * To use this in your HTML, link to it in the usual way:
 * <link rel="stylesheet" type="text/css" media="screen, print, projection" href="/css/compressed.css.php" />
 */
  
/* Add your CSS files to this array */
$cssFiles = array(
  //"template.css",
  "bootstrap.min.css",
  //"carousel.css",
  //"menu.css",
  "style.css"
);
/* Add dynamic CSS files that need to be executed to this array ie: style.css.php */ 
$cssPhpFiles = array(
 // "template.css.php"
);
 
/**
 * Ideally, you wouldn't need to change any code beyond this point.
 */
$buffer = "";
if(is_array($cssFiles)) {
  foreach ($cssFiles as $cssFile) {
    $buffer .= file_get_contents($cssFile);
  }
}

if(is_array($cssPhpFiles)) {
  foreach ($cssPhpFiles as $cssPhpFile) {
    ob_start();
    include $cssPhpFile;
    $buffer .= ob_get_contents();
    ob_end_clean();
  }
}
 
// Remove comments
$buffer = preg_replace('!/\*[^*]*\*+([^/][^*]*\*+)*/!', '', $buffer);
 
// Remove whitespace
//$buffer = preg_replace('/\s+/', '', $buffer);
$buffer = str_replace(array("\r\n", "\r", "\n", "\t", '  ', '    ', '    '), '', $buffer);
  
// Remove space after colons
$buffer = str_replace(': ', ':', $buffer);
$buffer = str_replace('; ', ';', $buffer);
$buffer = str_replace(array(' {', '{ '), '{', $buffer);
$buffer = str_replace(array(' }', '} '), '}', $buffer);
$buffer = str_replace(array(' ,', ', '), ',', $buffer);
$buffer = str_replace(array(' >', '> '), '>', $buffer);
$buffer = str_replace(array(' !', '! '), '!', $buffer);
 
// Enable GZip encoding.
ob_start("ob_gzhandler");
 
// Enable caching
header('Cache-Control: public');
 
// Expire in one day
header('Expires: ' . gmdate('D, d M Y H:i:s', time() + 86400) . ' GMT');
 
// Set the correct MIME type, because Apache won't set it for us
header("Content-type: text/css");
 
// Write everything out
echo($buffer);
?>