<?php
/**
 * @version    CVS: 1.0.0
 * @package    Com_Mmap
 * @author     David <davidgeorgespam@gmail.com>
 * @copyright  2017 David
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */
// No direct access
defined('_JEXEC') or die;

$canEdit = JFactory::getUser()->authorise('core.edit', 'com_mmap');

if (!$canEdit && JFactory::getUser()->authorise('core.edit.own', 'com_mmap'))
{
	$canEdit = JFactory::getUser()->id == $this->item->created_by;
}
?>

<div class="item_fields">

	<table class="table">
		

		<tr>
			<th><?php echo JText::_('COM_MMAP_FORM_LBL_MMAP_CATEGORY'); ?></th>
			<td><?php echo $this->item->category_title; ?></td>
		</tr>

		<tr>
			<th><?php echo JText::_('COM_MMAP_FORM_LBL_MMAP_TITLE'); ?></th>
			<td><?php echo $this->item->title; ?></td>
		</tr>

		<tr>
			<th><?php echo JText::_('COM_MMAP_FORM_LBL_MMAP_VISIT'); ?></th>
			<td><?php echo $this->item->visit; ?></td>
		</tr>

		<tr>
			<th><?php echo JText::_('COM_MMAP_FORM_LBL_MMAP_SELECT'); ?></th>
			<td><?php echo nl2br($this->item->select); ?></td>
		</tr>

		<tr>
			<th><?php echo JText::_('COM_MMAP_FORM_LBL_MMAP_FROM'); ?></th>
			<td><?php echo nl2br($this->item->from); ?></td>
		</tr>

		<tr>
			<th><?php echo JText::_('COM_MMAP_FORM_LBL_MMAP_WHERE'); ?></th>
			<td><?php echo nl2br($this->item->where); ?></td>
		</tr>

		<tr>
			<th><?php echo JText::_('COM_MMAP_FORM_LBL_MMAP_GROUP'); ?></th>
			<td><?php echo nl2br($this->item->group); ?></td>
		</tr>

	</table>

</div>

<?php if($canEdit && $this->item->checked_out == 0): ?>

	<a class="btn" href="<?php echo JRoute::_('index.php?option=com_mmap&task=mmap.edit&id='.$this->item->id); ?>"><?php echo JText::_("COM_MMAP_EDIT_ITEM"); ?></a>

<?php endif; ?>

<?php if (JFactory::getUser()->authorise('core.delete','com_mmap.mmap.'.$this->item->id)) : ?>

	<a class="btn btn-danger" href="#deleteModal" role="button" data-toggle="modal">
		<?php echo JText::_("COM_MMAP_DELETE_ITEM"); ?>
	</a>

	<div id="deleteModal" class="modal hide fade" tabindex="-1" role="dialog" aria-labelledby="deleteModal" aria-hidden="true">
		<div class="modal-header">
			<button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
			<h3><?php echo JText::_('COM_MMAP_DELETE_ITEM'); ?></h3>
		</div>
		<div class="modal-body">
			<p><?php echo JText::sprintf('COM_MMAP_DELETE_CONFIRM', $this->item->id); ?></p>
		</div>
		<div class="modal-footer">
			<button class="btn" data-dismiss="modal">Close</button>
			<a href="<?php echo JRoute::_('index.php?option=com_mmap&task=mmap.remove&id=' . $this->item->id, false, 2); ?>" class="btn btn-danger">
				<?php echo JText::_('COM_MMAP_DELETE_ITEM'); ?>
			</a>
		</div>
	</div>

<?php endif; ?>