<?php

/**
 * @version    CVS: 1.0.0
 * @package    Com_Mmap
 * @author     David <davidgeorgespam@gmail.com>
 * @copyright  2017 David
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */
// No direct access.
defined('_JEXEC') or die;

jimport('joomla.application.component.modelitem');
jimport('joomla.event.dispatcher');

use Joomla\Utilities\ArrayHelper;

/**
 * Mmap model.
 *
 * @since  1.6
 */
class MmapModelCompare extends JModelItem
{
	/**
	 * Method to auto-populate the model state.
	 *
	 * Note. Calling getState in this method will result in recursion.
	 *
	 * @return void
	 *
	 * @since    1.6
	 *
	 */
	protected function populateState()
	{
		$app  = JFactory::getApplication('com_mmap');
		$user = JFactory::getUser();

		// Check published state
		if ((!$user->authorise('core.edit.state', 'com_mmap')) && (!$user->authorise('core.edit', 'com_mmap')))
		{
			$this->setState('filter.published', 1);
			$this->setState('filter.archived', 2);
		}

		// Load state from the request userState on edit or from the passed variable on default
		if (JFactory::getApplication()->input->get('layout') == 'edit')
		{
			$id = JFactory::getApplication()->getUserState('com_mmap.edit.mmap.id');
		}
		else
		{
			$id = JFactory::getApplication()->input->get('id');
			JFactory::getApplication()->setUserState('com_mmap.edit.mmap.id', $id);
		}

		$this->setState('mmap.id', $id);

		// Load the parameters.
		$params       = $app->getParams();
		$params_array = $params->toArray();

		if (isset($params_array['item_id']))
		{
			$this->setState('mmap.id', $params_array['item_id']);
		}

		$this->setState('params', $params);
	}

	/**
	 * Method to get an object.
	 *
	 * @param   integer $id The id of the object to get.
	 *
	 * @return  mixed    Object on success, false on failure.
	 */
	public function &getData($id = null)
	{
		$return = array(); 
		$this->_item = array(); 
		
		/** Conditions */ 
		$conditions = new stdClass; 
		$conditions->paired_patient_visits = false;
		
		/** Variabkes */ 
		$from = 'pt_entry';          
		$visits = array(1,2); 
		//$normals = array('Total', 'Abnormal');
		$normals = array('Total');
		
		$db    = JFactory::getDbo();
    	$query = $db->getQuery(true);
    	        
    	$query->select('q.*, qt.qtable, qt.title as type');
    	$query->from($db->quoteName('queries', 'q'));
    	$query->join('LEFT', $db->quoteName('queries_types', 'qt') . ' ON q.type = qt.id ');   
    	$query->where('state = 1'); 
    	
    	$db->setQuery($query);
        echo $query->dump(); 
        	
        $measurements = $db->loadObjectList();
        
        echo '<pre>';
        //print_r($measurements);
    	echo '</pre>';
            	   
    	//$measurements = array(); 
		
		//$measurements = array('weight / POWER(height / 100, 2)', 'height', 'weight', 'waist_circumference', 'fasting_plasma_glucose', 'total_cholesterol', 'ldl_cholesterol', 'hdl_cholesterol', 'triglycerides', 'systolic', 'diastolic', 'time_until_next_review'); 
		
		$queries = new stdClass;
		
		//$queries->type = array('measurement', );
		
		
		//type, select, table, where, group, order
		//measurement, select, pt_entry, where, group, order
		
		
		foreach ($measurements as $measurement) {
		    foreach ($normals as $normal) {
        	    foreach ($visits as $visit) {  
        	        
        	        // If no abnormal condition is defined skip the query 
        	        if($normal == 'Abnormal' && empty($measurement->abnormal_condition)) {
        	            continue;
        	        }
        	        
        	        $abnormal_condition = $measurement->abnormal_condition; 
        	        $qwhere = $measurement->qwhere; 
        	            
        	            
        	            //$measurement->qwhere = '<b>  QWHERE ERROR  </b>';
        	            //$measurement->abnormal_condition = '<b>  AB ERROR </b> ';
        	            
        	           /** 
        	        if($visit == 1) {
            	        //$measurement->qwhere = str_replace('__IS_MALE__', "pe.gender = 'male'", $measurement->qwhere); 
            	       // $measurement->qwhere = str_replace('__IS_FEMALE__', "pe.gender = 'female'", $measurement->qwhere); 
            	       // $measurement->abnormal_condition = str_replace('__IS_MALE__', "pe.gender = 'male'",  $measurement->abnormal_condition); 
            	       // $measurement->abnormal_condition = str_replace('__IS_FEMALE__', "pe.gender = 'female'",  $measurement->abnormal_condition); 
            	        
            	        $measurement->qwhere = str_replace('__IS_MALE__', "pe.gender = 'male'", $qwhere); 
            	        $measurement->qwhere = str_replace('__IS_FEMALE__', "pe.gender = 'female'", $qwhere); 
            	        $measurement->abnormal_condition = str_replace('__IS_MALE__', "pe.gender = 'male'",  $abnormal_condition); 
            	        $measurement->abnormal_condition = str_replace('__IS_FEMALE__', "pe.gender = 'female'",  $abnormal_condition); 
        	        } elseif($visit == 2) {
            	       
            	         //$measurement->qwhere = str_replace('__IS_MALE__', "(SELECT gender from pt_entry WHERE patient_id = pe.patient_id AND visit = 1) = 'male'", $measurement->qwhere); 
        	           // $measurement->qwhere = str_replace('__IS_FEMALE__', "(SELECT gender from pt_entry WHERE patient_id = pe.patient_id AND visit = 1) = 'female'", $measurement->qwhere); 
        	           // $measurement->abnormal_condition = str_replace('__IS_MALE__', "(SELECT gender from pt_entry WHERE patient_id = pe.patient_id AND visit = 1) = 'male'",  $measurement->abnormal_condition); 
        	           // $measurement->abnormal_condition = str_replace('__IS_FEMALE__', "(SELECT gender from pt_entry WHERE patient_id = pe.patient_id AND visit = 1) = 'female'",  $measurement->abnormal_condition);
        	            
        	            //$qwhere = str_replace('__IS_MALE__', "(SELECT gender from pt_entry WHERE patient_id = pe.patient_id AND visit = 1) = 'male'", $measurement->qwhere); 
        	            //$qwhere = str_replace('__IS_FEMALE__', "(SELECT gender from pt_entry WHERE patient_id = pe.patient_id AND visit = 1) = 'female'", $measurement->qwhere); 
        	            //$abnormal_condition = str_replace('__IS_MALE__', "(SELECT gender from pt_entry WHERE patient_id = pe.patient_id AND visit = 1) = 'male'",  $measurement->abnormal_condition); 
        	            //$abnormal_condition = str_replace('__IS_FEMALE__', "(SELECT gender from pt_entry WHERE patient_id = pe.patient_id AND visit = 1) = 'female'",  $measurement->abnormal_condition); 
        	        } 
        	        
        	        
        	        
        	        
        	        //$male = (SELECT gender from pt_entry WHERE patient_id = pe.patient_id AND visit = 1) = 'male'
                    //$female = (SELECT gender from pt_entry WHERE patient_id = pe.patient_id AND visit = 1) = 'female'
        	        
        	        
        		    $db    = JFactory::getDbo();
        	        $query = $db->getQuery(true);
        	    
        	    
        	        // Standard Select for measurements 
        	        //$query->select('count(*) as n, AVG(' . $db->quoteName($measurement) .') as value, STD(' . $db->quoteName($measurement) .') as sd, min(' . $db->quoteName($measurement) .') as min, max(' . $db->quoteName($measurement) .') as max');       
        	        //$query->select('count(*) as n, AVG(' . $measurement .') as value, STD(' . $measurement .') as sd, min(' . $measurement .') as min, max(' . $measurement .') as max');       
        	        
        	        //CAST(fasting_plasma_glucose AS DECIMAL(12,2)))
        	         
        	        switch ($measurement->type) {
        	            case 'measurement': 
        	                
        	                $query->select('count(*) as n, AVG(CAST(' . $db->escape($measurement->query) .' AS DECIMAL(12,2))) as value, STD(CAST(' . $db->escape($measurement->query) .' AS DECIMAL(12,2))) as sd, min(CAST(' . $db->escape($measurement->query) .' AS DECIMAL(12,2))) as min, max(CAST(' . $db->escape($measurement->query) .' AS DECIMAL(12,2))) as max');     
        	            
        	            if(!empty($measurement->query)) {
                                $min_value = (!empty($measurement->min_value)) ? $measurement->min_value : 0; 
                                
                                $query->where($measurement->query . ' > ' . $db->escape($min_value)); 
                        
                                if(!empty($measurement->max_value)) {
                                    $query->where($measurement->query . ' < ' . $db->escape($measurement->max_value)); 
                                }
                            }
        	            break; 
                        case 'measurement_advanced': 
        	                $query->select('count(*) as n, AVG(' . $measurement->query .') as value, STD(' . $measurement->query .') as sd, min(' . $measurement->query .') as min, max(' . $measurement->query .') as max');     
        	                
        	                if(!empty($measurement->query)) {
                                $min_value = (!empty($measurement->min_value)) ? $measurement->min_value : 0; 
                                
                                $query->where($measurement->query . ' > ' . $db->escape($min_value)); 
                        
                                if(!empty($measurement->max_value)) {
                                    $query->where($measurement->query . ' < ' . $db->escape($measurement->max_value)); 
                                }
                            }
        	            break; 
        	            case 'count': 
        	                $query->select('count(*) as n, count(*) as value, count(*) as sd,count(*) as min, count(*) as max'); 
        	            break; 
        	        }
        	        
        	        
        	        
        		            
                    switch($measurement->qtable) {
            		    case 'users':
                            $query->from($db->quoteName('users', 'u'));
            		    break;  
            		    case 'patients': 
            		        $query->from($db->quoteName('patients', 'p'));
            		        $query->join('LEFT', $db->quoteName('users', 'u') . ' ON u.id = p.user_id '); 
            		        $query->join('LEFT', $db->quoteName('pt_entry', 'pe') . ' ON p.id = pe.patient_id');
            		    break; 
            		    case 'pt_entry':
            		    default:
                		    $query->from($db->quoteName('pt_entry', 'pe'));
                		    $query->join('LEFT', $db->quoteName('patients', 'p') . ' ON p.id = pe.patient_id ');
                		    $query->join('LEFT', $db->quoteName('users', 'u') . ' ON u.id = p.user_id '); 
            		    break; 
            		    case 'medications': 
            		        $query->from($db->quoteName('medications', 'm'));
            		        $query->join('LEFT', $db->quoteName('medications_map', 'mm') . ' ON mm.id = m.med_id');
            		        $query->join('LEFT', $db->quoteName('pt_entry', 'pe') . ' ON pe.id = m.pt_entry_id');
                		    $query->join('LEFT', $db->quoteName('patients', 'p') . ' ON p.id = pe.patient_id ');
                		    $query->join('LEFT', $db->quoteName('users', 'u') . ' ON u.id = p.user_id '); 
            		    break; 
            		}
            		
                    /** Add conditions */
                    if($from != 'users' && $conditions->paired_patient_visits == true) {
                        // Select only record that have a follow up visit 
                        $query->where('(SELECT count(patient_id) FROM pt_entry  WHERE patient_id = pe.patient_id) = 2');     
                    }
                    
                    /** 
                     * $male = (SELECT gender from pt_entry WHERE patient_id = pe.patient_id AND visit = 1) = 'male'
                     * $female = (SELECT gender from pt_entry WHERE patient_id = pe.patient_id AND visit = 1) = 'female'
                     * */
                    
                    
                    /** Metabolic Syndrome Elements */ 
                    
                    
                    
                    
                    // Waist Elevated 
                    //(((waist_circumference >= 94 AND __IS_MALE__) OR (waist_circumference >= 80 AND __IS_FEMALE__)) AND (waist_circumference < 200))
                    
                    // BMI Elevated 
                    //(((`weight` / POWER(`height` / 100, 2)) > 30) AND ((`weight` / POWER(`height` / 100, 2)) < 100))
                    //
                    
                    //Elevated Fasting Plasma Glucose
                    //((fasting_plasma_glucose > 5.5) AND (fasting_plasma_glucose < 20))
                    
                    //Reduced HDL
                    //(((hdl_cholesterol < 1.03 AND __IS_MALE__) OR (hdl_cholesterol < 1.29 AND __IS_FEMALE__)) AND (hdl_cholesterol < 5))
                   
                    
                    // Elevated Triglycerides
                     
                    //((triglycerides > 1.7)  AND (triglycerides < 10))
                    // 
                    
                    
                    // Raised BP 
                    //((systolic > 130 OR diastolic > 85) AND (systolic < 250 AND diastolic < 200))
                    
                    
                    /** Metabolic Syndrome  */ 
                    /**
                    $mets = '(' . $raised_waist_circumfirence . ' OR ' . $raised_bmi .') ' . 
                    ' AND (' . 
                        'case when ' . $raised_fasting_plasma_glucose . ' then 1 else 0 end ' .
                        'case when ' . $reduced_hdl_cholesterol . ' then 1 else 0 end ' .
                        'case when ' . $raised_triglycerides . ' then 1 else 0 end ' .
                        'case when ' . $raised_bp . ' then 1 else 0 end ' .
                        ' >= 2' . 
                        ')';
                        */
                        
                    // Toggle the Visit 
                    $query->where('visit = ' . $db->escape($visit)); 
                    
                    
                    /**
                    // Add custom conditions 
                    if($normal == 'Total' && !empty($measurement->qwhere)) {
                        $query->where($qwhere); 
                    }
                    
                    if($normal == 'Abnormal' && !empty($measurement->abnormal_condition)) {
                        $query->where($abnormal_condition); 
                    }
        		  */
        		  
            		 // Remove servier and Allori pts 
                    $query->where('u.email NOT LIKE ' . $db->quote('%@servier%') . 
                        ' AND u.email NOT LIKE ' . $db->quote('%@allori%') . 
                        //' AND u.admin != ' . $db->quote('1') . 
                        ' AND u.aphra_number LIKE ' . $db->quote('MED%'));   
                    
                    //$query->setlimit(3); 
                    
                    // Add Custom Group 
                    if(!empty($measurement->qgroup)) {
                        $query->group($measurement->qgroup); 
                    }
                    
                    // Add Custom Order 
                    if(!empty($measurement->qorder)) {
                        $query->order($measurement->qorder); 
                    }
               
            		//$query->order('pe.patient_id ASC'); 
            		$db->setQuery($query);
            		
            		echo $measurement->title . ' - ' . $normal . ' - v' . $visit;
            		echo $query->dump(); 
            		
            		//$this->_item[$measurement->title][$normal]['v' . $visit] = $db->loadObject();
    	        }
		    }
		}
		
		
        return $this->_item;
	}

	/**
	 * Get an instance of JTable class
	 *
	 * @param   string $type   Name of the JTable class to get an instance of.
	 * @param   string $prefix Prefix for the table class name. Optional.
	 * @param   array  $config Array of configuration values for the JTable object. Optional.
	 *
	 * @return  JTable|bool JTable if success, false on failure.
	 */
	public function getTable($type = 'Mmap', $prefix = 'MmapTable', $config = array())
	{
		$this->addTablePath(JPATH_ADMINISTRATOR . '/components/com_mmap/tables');

		return JTable::getInstance($type, $prefix, $config);
	}
	
	private function saveResults($result) {
	    
	    
	    $db    = JFactory::getDbo();
    	$query = $db->getQuery(true);
    	        
    	$query->select('r.id');
    	$query->from($db->quoteName('results', 'r'));
    	$query->where('query_id = ' . $db->quote($item->query_id) . ' AND normal = ' . $db->quote($item->normal) . ' AND visit = ' . $db->quote($item->visit)); 
    	
    	$measurements = $db->loadObject();
        
        
	    
	    $db    = JFactory::getDbo();
    	$query = $db->getQuery(true);
    	
    	$object             = new stdClass; 
    	$object->query_id   = (int) $item->query_id; 		
    	$object->normal	    = $item->normal; 
    	$object->visit      = (int) $item->visit; 	
    	$object->mean       = $item->value; 	
    	$object->sd	        = $item->sd; 	
    	$object->rmin       = $item->min; 	
    	$object->rmax       = $item->max; 	
    	$object->n          = $item->n; 
    	$object->query      = $item->query; 
    	$object->created    = JFactory::getDate()->toSql(); 
    	$object->updated    = JFactory::getDate()->toSql();  

    	        
        $result = JFactory::getDbo()->insertObject('#__results', $object);
        
        $result = JFactory::getDbo()->updateObject('#__results', $object, 'id');
	    
	}

	

	
}
