<?php
/**
 * @version    CVS: 1.0.0
 * @package    Com_Invoices
 * @author     David George <info@bluelinetechnology.com.au>
 * @copyright  2018 Blueline Technology
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */
// No direct access
defined('_JEXEC') or die;

$canEdit = JFactory::getUser()->authorise('core.edit', 'com_invoices');

if (!$canEdit && JFactory::getUser()->authorise('core.edit.own', 'com_invoices'))
{
	$canEdit = JFactory::getUser()->id == $this->item->created_by;
}
?>

<div class="item_fields">

	<table class="table">
		

		<tr>
			<th><?php echo JText::_('COM_INVOICES_FORM_LBL_INVOICE_DATE'); ?></th>
			<td><?php echo $this->item->date; ?></td>
		</tr>

		<tr>
			<th><?php echo JText::_('COM_INVOICES_FORM_LBL_INVOICE_CLIENT'); ?></th>
			<td><?php echo $this->item->client; ?></td>
		</tr>

		<tr>
			<th><?php echo JText::_('COM_INVOICES_FORM_LBL_INVOICE_ITEMS'); ?></th>
			<td><?php echo $this->item->items; ?></td>
		</tr>

		<tr>
			<th><?php echo JText::_('COM_INVOICES_FORM_LBL_INVOICE_STATUS'); ?></th>
			<td><?php echo $this->item->status; ?></td>
		</tr>

		<tr>
			<th><?php echo JText::_('COM_INVOICES_FORM_LBL_INVOICE_INTERVAL'); ?></th>
			<td><?php echo $this->item->interval; ?></td>
		</tr>

		<tr>
			<th><?php echo JText::_('COM_INVOICES_FORM_LBL_INVOICE_CAPTCHA'); ?></th>
			<td><?php echo $this->item->captcha; ?></td>
		</tr>

		<tr>
			<th><?php echo JText::_('COM_INVOICES_FORM_LBL_INVOICE_CREATED'); ?></th>
			<td><?php echo $this->item->created; ?></td>
		</tr>

		<tr>
			<th><?php echo JText::_('COM_INVOICES_FORM_LBL_INVOICE_UPDATED'); ?></th>
			<td><?php echo $this->item->updated; ?></td>
		</tr>

	</table>

</div>

<?php if($canEdit && $this->item->checked_out == 0): ?>

	<a class="btn" href="<?php echo JRoute::_('index.php?option=com_invoices&task=invoice.edit&id='.$this->item->id); ?>"><?php echo JText::_("COM_INVOICES_EDIT_ITEM"); ?></a>

<?php endif; ?>

<?php if (JFactory::getUser()->authorise('core.delete','com_invoices.invoice.'.$this->item->id)) : ?>

	<a class="btn btn-danger" href="#deleteModal" role="button" data-toggle="modal">
		<?php echo JText::_("COM_INVOICES_DELETE_ITEM"); ?>
	</a>

	<div id="deleteModal" class="modal hide fade" tabindex="-1" role="dialog" aria-labelledby="deleteModal" aria-hidden="true">
		<div class="modal-header">
			<button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
			<h3><?php echo JText::_('COM_INVOICES_DELETE_ITEM'); ?></h3>
		</div>
		<div class="modal-body">
			<p><?php echo JText::sprintf('COM_INVOICES_DELETE_CONFIRM', $this->item->id); ?></p>
		</div>
		<div class="modal-footer">
			<button class="btn" data-dismiss="modal">Close</button>
			<a href="<?php echo JRoute::_('index.php?option=com_invoices&task=invoice.remove&id=' . $this->item->id, false, 2); ?>" class="btn btn-danger">
				<?php echo JText::_('COM_INVOICES_DELETE_ITEM'); ?>
			</a>
		</div>
	</div>

<?php endif; ?>