<?php
/**
 * @version    CVS: 1.0.0
 * @package    Com_Budget
 * @author     David <davidgeorgespam@gmail.com>
 * @copyright  2018 David
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */
// No direct access
defined('_JEXEC') or die;

$canEdit = JFactory::getUser()->authorise('core.edit', 'com_budget');

if (!$canEdit && JFactory::getUser()->authorise('core.edit.own', 'com_budget'))
{
	$canEdit = JFactory::getUser()->id == $this->item->created_by;
}
?>

<div class="item_fields">

	<table class="table">
		

		<tr>
			<th><?php echo JText::_('COM_BUDGET_FORM_LBL_STATEMENT_DATE'); ?></th>
			<td><?php echo $this->item->date; ?></td>
		</tr>

		<tr>
			<th><?php echo JText::_('COM_BUDGET_FORM_LBL_STATEMENT_DATE_EFFECTIVE'); ?></th>
			<td><?php echo $this->item->date_effective; ?></td>
		</tr>

		<tr>
			<th><?php echo JText::_('COM_BUDGET_FORM_LBL_STATEMENT_DESCRIPTION'); ?></th>
			<td><?php echo $this->item->description; ?></td>
		</tr>

		<tr>
			<th><?php echo JText::_('COM_BUDGET_FORM_LBL_STATEMENT_AMOUNT'); ?></th>
			<td><?php echo $this->item->amount; ?></td>
		</tr>

		<tr>
			<th><?php echo JText::_('COM_BUDGET_FORM_LBL_STATEMENT_BALANCE'); ?></th>
			<td><?php echo $this->item->balance; ?></td>
		</tr>

		<tr>
			<th><?php echo JText::_('COM_BUDGET_FORM_LBL_STATEMENT_VENDOR_ID'); ?></th>
			<td><?php echo $this->item->vendor_id; ?></td>
		</tr>

		<tr>
			<th><?php echo JText::_('COM_BUDGET_FORM_LBL_STATEMENT_ACCOUNT_ID'); ?></th>
			<td><?php echo $this->item->account_id; ?></td>
		</tr>

	</table>

</div>

<?php if($canEdit && $this->item->checked_out == 0): ?>

	<a class="btn" href="<?php echo JRoute::_('index.php?option=com_budget&task=statement.edit&id='.$this->item->id); ?>"><?php echo JText::_("COM_BUDGET_EDIT_ITEM"); ?></a>

<?php endif; ?>

<?php if (JFactory::getUser()->authorise('core.delete','com_budget.statement.'.$this->item->id)) : ?>

	<a class="btn btn-danger" href="#deleteModal" role="button" data-toggle="modal">
		<?php echo JText::_("COM_BUDGET_DELETE_ITEM"); ?>
	</a>

	<div id="deleteModal" class="modal hide fade" tabindex="-1" role="dialog" aria-labelledby="deleteModal" aria-hidden="true">
		<div class="modal-header">
			<button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
			<h3><?php echo JText::_('COM_BUDGET_DELETE_ITEM'); ?></h3>
		</div>
		<div class="modal-body">
			<p><?php echo JText::sprintf('COM_BUDGET_DELETE_CONFIRM', $this->item->id); ?></p>
		</div>
		<div class="modal-footer">
			<button class="btn" data-dismiss="modal">Close</button>
			<a href="<?php echo JRoute::_('index.php?option=com_budget&task=statement.remove&id=' . $this->item->id, false, 2); ?>" class="btn btn-danger">
				<?php echo JText::_('COM_BUDGET_DELETE_ITEM'); ?>
			</a>
		</div>
	</div>

<?php endif; ?>