<?php
/**
 * @version    CVS: 1.0.0
 * @package    Com_Invoices
 * @author     David George <info@bluelinetechnology.com.au>
 * @copyright  2018 Blueline Technology
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */
// No direct access
defined('_JEXEC') or die;

JHtml::addIncludePath(JPATH_COMPONENT . '/helpers/html');
JHtml::_('behavior.tooltip');
JHtml::_('behavior.formvalidation');
JHtml::_('formbehavior.chosen', 'select');
JHtml::_('behavior.keepalive');

// Import CSS
$document = JFactory::getDocument();
$document->addStyleSheet(JUri::root() . 'media/com_invoices/css/form.css');
?>
<script type="text/javascript">
	js = jQuery.noConflict();
	js(document).ready(function () {
		
	js('input:hidden.client').each(function(){
		var name = js(this).attr('name');
		if(name.indexOf('clienthidden')){
			js('#jform_client option[value="'+js(this).val()+'"]').attr('selected',true);
		}
	});
	js("#jform_client").trigger("liszt:updated");
	js('input:hidden.status').each(function(){
		var name = js(this).attr('name');
		if(name.indexOf('statushidden')){
			js('#jform_status option[value="'+js(this).val()+'"]').attr('selected',true);
		}
	});
	js("#jform_status").trigger("liszt:updated");
	});

	Joomla.submitbutton = function (task) {
		if (task == 'invoice.cancel') {
			Joomla.submitform(task, document.getElementById('invoice-form'));
		}
		else {
			
			if (task != 'invoice.cancel' && document.formvalidator.isValid(document.id('invoice-form'))) {
				
				Joomla.submitform(task, document.getElementById('invoice-form'));
			}
			else {
				alert('<?php echo $this->escape(JText::_('JGLOBAL_VALIDATION_FORM_FAILED')); ?>');
			}
		}
	}
</script>

<form
	action="<?php echo JRoute::_('index.php?option=com_invoices&layout=edit&id=' . (int) $this->item->id); ?>"
	method="post" enctype="multipart/form-data" name="adminForm" id="invoice-form" class="form-validate">

	<div class="form-horizontal">
		<?php echo JHtml::_('bootstrap.startTabSet', 'myTab', array('active' => 'general')); ?>

		<?php echo JHtml::_('bootstrap.addTab', 'myTab', 'general', JText::_('COM_INVOICES_TITLE_INVOICE', true)); ?>
		<div class="row-fluid">
			<div class="span10 form-horizontal">
				<fieldset class="adminform">

									<input type="hidden" name="jform[id]" value="<?php echo $this->item->id; ?>" />
				<?php echo $this->form->renderField('date'); ?>
				<?php echo $this->form->renderField('client'); ?>

			<?php
				foreach((array)$this->item->client as $value): 
					if(!is_array($value)):
						echo '<input type="hidden" class="client" name="jform[clienthidden]['.$value.']" value="'.$value.'" />';
					endif;
				endforeach;
			?>				<?php echo $this->form->renderField('items'); ?>
				<?php echo $this->form->renderField('status'); ?>

			<?php
				foreach((array)$this->item->status as $value): 
					if(!is_array($value)):
						echo '<input type="hidden" class="status" name="jform[statushidden]['.$value.']" value="'.$value.'" />';
					endif;
				endforeach;
			?>				<?php echo $this->form->renderField('interval'); ?>
				<?php echo $this->form->renderField('captcha'); ?>
				<input type="hidden" name="jform[ordering]" value="<?php echo $this->item->ordering; ?>" />
				<input type="hidden" name="jform[state]" value="<?php echo $this->item->state; ?>" />
				<input type="hidden" name="jform[checked_out]" value="<?php echo $this->item->checked_out; ?>" />
				<input type="hidden" name="jform[checked_out_time]" value="<?php echo $this->item->checked_out_time; ?>" />
				<?php echo $this->form->renderField('created'); ?>
				<?php echo $this->form->renderField('updated'); ?>

				<?php echo $this->form->renderField('created_by'); ?>
				<?php echo $this->form->renderField('modified_by'); ?>

					<?php if ($this->state->params->get('save_history', 1)) : ?>
					<div class="control-group">
						<div class="control-label"><?php echo $this->form->getLabel('version_note'); ?></div>
						<div class="controls"><?php echo $this->form->getInput('version_note'); ?></div>
					</div>
					<?php endif; ?>
				</fieldset>
			</div>
		</div>
		<?php echo JHtml::_('bootstrap.endTab'); ?>

		

		<?php echo JHtml::_('bootstrap.endTabSet'); ?>

		<input type="hidden" name="task" value=""/>
		<?php echo JHtml::_('form.token'); ?>

	</div>
</form>
