<?php
/**
 * @version    CVS: 1.0.0
 * @package    Com_Budget
 * @author     David <davidgeorgespam@gmail.com>
 * @copyright  2018 David
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */
// No direct access
defined('_JEXEC') or die;

JHtml::addIncludePath(JPATH_COMPONENT . '/helpers/html');
JHtml::_('behavior.tooltip');
JHtml::_('behavior.formvalidation');
JHtml::_('formbehavior.chosen', 'select');
JHtml::_('behavior.keepalive');

// Import CSS
$document = JFactory::getDocument();
$document->addStyleSheet(JUri::root() . 'media/com_budget/css/form.css');
?>
<script type="text/javascript">
	js = jQuery.noConflict();
	js(document).ready(function () {
		
	js('input:hidden.vendor_id').each(function(){
		var name = js(this).attr('name');
		if(name.indexOf('vendor_idhidden')){
			js('#jform_vendor_id option[value="'+js(this).val()+'"]').attr('selected',true);
		}
	});
	js("#jform_vendor_id").trigger("liszt:updated");
	js('input:hidden.account_id').each(function(){
		var name = js(this).attr('name');
		if(name.indexOf('account_idhidden')){
			js('#jform_account_id option[value="'+js(this).val()+'"]').attr('selected',true);
		}
	});
	js("#jform_account_id").trigger("liszt:updated");
	});

	Joomla.submitbutton = function (task) {
		if (task == 'statement.cancel') {
			Joomla.submitform(task, document.getElementById('statement-form'));
		}
		else {
			
			if (task != 'statement.cancel' && document.formvalidator.isValid(document.id('statement-form'))) {
				
				Joomla.submitform(task, document.getElementById('statement-form'));
			}
			else {
				alert('<?php echo $this->escape(JText::_('JGLOBAL_VALIDATION_FORM_FAILED')); ?>');
			}
		}
	}
</script>

<form
	action="<?php echo JRoute::_('index.php?option=com_budget&layout=edit&id=' . (int) $this->item->id); ?>"
	method="post" enctype="multipart/form-data" name="adminForm" id="statement-form" class="form-validate">

	<div class="form-horizontal">
		<?php echo JHtml::_('bootstrap.startTabSet', 'myTab', array('active' => 'general')); ?>

		<?php echo JHtml::_('bootstrap.addTab', 'myTab', 'general', JText::_('COM_BUDGET_TITLE_STATEMENT', true)); ?>
		<div class="row-fluid">
			<div class="span10 form-horizontal">
				<fieldset class="adminform">

									<input type="hidden" name="jform[id]" value="<?php echo $this->item->id; ?>" />
				<?php echo $this->form->renderField('date'); ?>
				<?php echo $this->form->renderField('date_effective'); ?>
				<?php echo $this->form->renderField('description'); ?>
				<?php echo $this->form->renderField('amount'); ?>
				<?php echo $this->form->renderField('balance'); ?>
				<?php echo $this->form->renderField('vendor_id'); ?>

			<?php
				foreach((array)$this->item->vendor_id as $value): 
					if(!is_array($value)):
						echo '<input type="hidden" class="vendor_id" name="jform[vendor_idhidden]['.$value.']" value="'.$value.'" />';
					endif;
				endforeach;
			?>				<?php echo $this->form->renderField('account_id'); ?>

			<?php
				foreach((array)$this->item->account_id as $value): 
					if(!is_array($value)):
						echo '<input type="hidden" class="account_id" name="jform[account_idhidden]['.$value.']" value="'.$value.'" />';
					endif;
				endforeach;
			?>				<input type="hidden" name="jform[ordering]" value="<?php echo $this->item->ordering; ?>" />
				<input type="hidden" name="jform[state]" value="<?php echo $this->item->state; ?>" />
				<input type="hidden" name="jform[checked_out]" value="<?php echo $this->item->checked_out; ?>" />
				<input type="hidden" name="jform[checked_out_time]" value="<?php echo $this->item->checked_out_time; ?>" />

				<?php echo $this->form->renderField('created_by'); ?>
				<?php echo $this->form->renderField('modified_by'); ?>

					<?php if ($this->state->params->get('save_history', 1)) : ?>
					<div class="control-group">
						<div class="control-label"><?php echo $this->form->getLabel('version_note'); ?></div>
						<div class="controls"><?php echo $this->form->getInput('version_note'); ?></div>
					</div>
					<?php endif; ?>
				</fieldset>
			</div>
		</div>
		<?php echo JHtml::_('bootstrap.endTab'); ?>

		

		<?php echo JHtml::_('bootstrap.endTabSet'); ?>

		<input type="hidden" name="task" value=""/>
		<?php echo JHtml::_('form.token'); ?>

	</div>
</form>
