<?php

/**
 * @version    CVS: 1.0.0
 * @package    Com_Budget
 * @author     David <davidgeorgespam@gmail.com>
 * @copyright  2018 David
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

jimport('joomla.application.component.modellist');

/**
 * Methods supporting a list of Budget records.
 *
 * @since  1.6
 */
class BudgetModelStatements extends JModelList
{
    
        
/**
	* Constructor.
	*
	* @param   array  $config  An optional associative array of configuration settings.
	*
	* @see        JController
	* @since      1.6
	*/
	public function __construct($config = array())
	{
		if (empty($config['filter_fields']))
		{
			$config['filter_fields'] = array(
				'id', 'a.`id`',
				'date', 'a.`date`',
				'date_effective', 'a.`date_effective`',
				'description', 'a.`description`',
				'amount', 'a.`amount`',
				'balance', 'a.`balance`',
				'vendor_id', 'a.`vendor_id`',
				'account_id', 'a.`account_id`',
				'ordering', 'a.`ordering`',
				'state', 'a.`state`',
				'created_by', 'a.`created_by`',
				'modified_by', 'a.`modified_by`',
			);
		}

		parent::__construct($config);
	}

    
        
    
        
	/**
	 * Method to auto-populate the model state.
	 *
	 * Note. Calling getState in this method will result in recursion.
	 *
	 * @param   string  $ordering   Elements order
	 * @param   string  $direction  Order direction
	 *
	 * @return void
	 *
	 * @throws Exception
	 */
	protected function populateState($ordering = null, $direction = null)
	{
        // List state information.
        parent::populateState('a.ordering', 'asc');

        $context = $this->getUserStateFromRequest($this->context . '.context', 'context', 'com_content.article', 'CMD');
        $this->setState('filter.context', $context);

        // Split context into component and optional section
        $parts = FieldsHelper::extract($context);

        if ($parts)
        {
            $this->setState('filter.component', $parts[0]);
            $this->setState('filter.section', $parts[1]);
        }
	}

	/**
	 * Method to get a store id based on model configuration state.
	 *
	 * This is necessary because the model is used by the component and
	 * different modules that might need different sets of data or different
	 * ordering requirements.
	 *
	 * @param   string  $id  A prefix for the store id.
	 *
	 * @return   string A store id.
	 *
	 * @since    1.6
	 */
	protected function getStoreId($id = '')
	{
		// Compile the store id.
		$id .= ':' . $this->getState('filter.search');
		$id .= ':' . $this->getState('filter.state');

                
                    return parent::getStoreId($id);
                
	}

	/**
	 * Build an SQL query to load the list data.
	 *
	 * @return   JDatabaseQuery
	 *
	 * @since    1.6
	 */
	protected function getListQuery()
	{
		// Create a new query object.
		$db    = $this->getDbo();
		$query = $db->getQuery(true);

		// Select the required fields from the table.
		$query->select(
			$this->getState(
				'list.select', 'DISTINCT a.*'
			)
		);
		$query->from('`#__budget_statements` AS a');
                
		// Join over the users for the checked out user
		$query->select("uc.name AS uEditor");
		$query->join("LEFT", "#__users AS uc ON uc.id=a.checked_out");
		// Join over the foreign key 'vendor_id'
		$query->select('`#__com_budget_vendors_3151136`.`title` AS #__com_budget_vendors_fk_value_3151136');
		$query->join('LEFT', '#__com_budget_vendors AS #__com_budget_vendors_3151136 ON #__com_budget_vendors_3151136.`id` = a.`vendor_id`');
		// Join over the foreign key 'account_id'
		$query->select('`#__com_budget_accounts_3151138`.`title` AS #__com_budget_accounts_fk_value_3151138');
		$query->join('LEFT', '#__com_budget_accounts AS #__com_budget_accounts_3151138 ON #__com_budget_accounts_3151138.`id` = a.`account_id`');

		// Join over the user field 'created_by'
		$query->select('`created_by`.name AS `created_by`');
		$query->join('LEFT', '#__users AS `created_by` ON `created_by`.id = a.`created_by`');

		// Join over the user field 'modified_by'
		$query->select('`modified_by`.name AS `modified_by`');
		$query->join('LEFT', '#__users AS `modified_by` ON `modified_by`.id = a.`modified_by`');
                

		// Filter by published state
		$published = $this->getState('filter.state');

		if (is_numeric($published))
		{
			$query->where('a.state = ' . (int) $published);
		}
		elseif ($published === '')
		{
			$query->where('(a.state IN (0, 1))');
		}

		// Filter by search in title
		$search = $this->getState('filter.search');

		if (!empty($search))
		{
			if (stripos($search, 'id:') === 0)
			{
				$query->where('a.id = ' . (int) substr($search, 3));
			}
			else
			{
				$search = $db->Quote('%' . $db->escape($search, true) . '%');
				
			}
		}
                

		// Filtering date
		$filter_date_from = $this->state->get("filter.date.from");

		if ($filter_date_from !== null && !empty($filter_date_from))
		{
			$query->where("a.`date` >= '".$db->escape($filter_date_from)."'");
		}
		$filter_date_to = $this->state->get("filter.date.to");

		if ($filter_date_to !== null  && !empty($filter_date_to))
		{
			$query->where("a.`date` <= '".$db->escape($filter_date_to)."'");
		}

		// Filtering vendor_id
		$filter_vendor_id = $this->state->get("filter.vendor_id");

		if ($filter_vendor_id !== null && !empty($filter_vendor_id))
		{
			$query->where("a.`vendor_id` = '".$db->escape($filter_vendor_id)."'");
		}

		// Filtering account_id
		$filter_account_id = $this->state->get("filter.account_id");

		if ($filter_account_id !== null && !empty($filter_account_id))
		{
			$query->where("a.`account_id` = '".$db->escape($filter_account_id)."'");
		}
		// Add the list ordering clause.
		$orderCol  = $this->state->get('list.ordering', 'date');
		$orderDirn = $this->state->get('list.direction', 'DESC');

		if ($orderCol && $orderDirn)
		{
			$query->order($db->escape($orderCol . ' ' . $orderDirn));
		}

		return $query;
	}

	/**
	 * Get an array of data items
	 *
	 * @return mixed Array of data items on success, false on failure.
	 */
	public function getItems()
	{
		$items = parent::getItems();
                
		foreach ($items as $oneItem)
		{

			if (isset($oneItem->vendor_id))
			{
				$values    = explode(',', $oneItem->vendor_id);
				$textValue = array();

				foreach ($values as $value)
				{
					$db    = JFactory::getDbo();
					$query = $db->getQuery(true);
					$query
						->select('`#__com_budget_vendors_3151136`.`title`')
						->from($db->quoteName('#__com_budget_vendors', '#__com_budget_vendors_3151136'))
						->where($db->quoteName('#__com_budget_vendors_3151136.id') . ' = '. $db->quote($db->escape($value)));

					$db->setQuery($query);
					$results = $db->loadObject();

					if ($results)
					{
						$textValue[] = $results->title;
					}
				}

				$oneItem->vendor_id = !empty($textValue) ? implode(', ', $textValue) : $oneItem->vendor_id;
			}

			if (isset($oneItem->account_id))
			{
				$values    = explode(',', $oneItem->account_id);
				$textValue = array();

				foreach ($values as $value)
				{
					$db    = JFactory::getDbo();
					$query = $db->getQuery(true);
					$query
						->select('`#__com_budget_accounts_3151138`.`title`')
						->from($db->quoteName('#__com_budget_accounts', '#__com_budget_accounts_3151138'))
						->where($db->quoteName('#__com_budget_accounts_3151138.id') . ' = '. $db->quote($db->escape($value)));

					$db->setQuery($query);
					$results = $db->loadObject();

					if ($results)
					{
						$textValue[] = $results->title;
					}
				}

				$oneItem->account_id = !empty($textValue) ? implode(', ', $textValue) : $oneItem->account_id;
			}
		}

		return $items;
	}
}
